/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.apache.openejb.client.ApplicationException;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.EJBObjectProxy;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.RequestMethodCode;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.SystemError;
import org.apache.openejb.client.SystemException;
import org.apache.openejb.client.ThrowableArtifact;

public class EntityEJBObjectHandler
extends EJBObjectHandler {
    public EntityEJBObjectHandler() {
    }

    public EntityEJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        super(ejb, server, client);
    }

    public EntityEJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey) {
        super(ejb, server, client, primaryKey);
        this.registryId = ejb.deploymentID + ":" + primaryKey;
        EntityEJBObjectHandler.registerHandler(this.registryId, this);
    }

    @Override
    public Object getRegistryId() {
        return this.registryId;
    }

    @Override
    protected Object getPrimaryKey(Method method, Object[] args, Object proxy) throws Throwable {
        return this.primaryKey;
    }

    @Override
    protected Object isIdentical(Method method, Object[] args, Object proxy) throws Throwable {
        if (args[0] == null) {
            return Boolean.FALSE;
        }
        EJBObjectProxy ejbObject = (EJBObjectProxy)args[0];
        EJBObjectHandler that = ejbObject.getEJBObjectHandler();
        return new Boolean(this.registryId.equals(that.registryId));
    }

    @Override
    protected Object equals(Method method, Object[] args, Object proxy) throws Throwable {
        return this.isIdentical(method, args, proxy);
    }

    @Override
    protected Object remove(Method method, Object[] args, Object proxy) throws Throwable {
        EJBRequest req = new EJBRequest(RequestMethodCode.EJB_OBJECT_REMOVE, this.ejb, method, args, this.primaryKey);
        EJBResponse res = this.request(req);
        switch (res.getResponseCode()) {
            case 11: {
                throw new SystemError((ThrowableArtifact)res.getResult());
            }
            case 10: {
                throw new SystemException((ThrowableArtifact)res.getResult());
            }
            case 9: {
                throw new ApplicationException((ThrowableArtifact)res.getResult());
            }
            case 4: {
                EntityEJBObjectHandler.invalidateAllHandlers(this.getRegistryId());
                return null;
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }

    @Override
    protected void invalidateReference() {
    }
}

