/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.navigation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.common.navigation.InvalidNavigationException;
import org.odftoolkit.simple.common.navigation.Navigation;
import org.odftoolkit.simple.common.navigation.ParagraphSelection;
import org.odftoolkit.simple.common.navigation.Selection;
import org.odftoolkit.simple.common.navigation.TextNavigation;
import org.odftoolkit.simple.common.navigation.TextSelection;
import org.odftoolkit.simple.style.ParagraphProperties;
import org.odftoolkit.simple.style.TableProperties;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.text.Paragraph;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableSelection
extends Selection {
    private TextSelection textSelection;
    private Table tableContainer;
    private Table sourceTable;

    public Table replaceWithTable(Table table) {
        this.sourceTable = table;
        if (this.search instanceof TextNavigation) {
            int leftLength = this.textSelection.getText().length();
            int index = this.textSelection.getIndex();
            boolean continued = false;
            TextNavigation textSearch = (TextNavigation)this.search;
            if (textSearch != null && textSearch.getReplacedItem() != null && textSearch.getReplacedItem().getElement() == this.textSelection.getElement()) {
                continued = true;
            } else {
                textSearch.setHandlePageBreak(false);
            }
            this.preparetableContainer(leftLength, index, continued);
            Selection.SelectionManager.unregisterItem(this.textSelection);
            if (textSearch != null) {
                textSearch.setReplacedItem(this.textSelection);
                Paragraph lastParagraph = this.getLastParagraphInTable(this.tableContainer);
                Object newStartPoint = lastParagraph != null ? lastParagraph.getOdfElement() : this.tableContainer.getOdfElement();
                String content = TextExtractor.getText((OdfElement)newStartPoint);
                TextSelection selected = this.newTextSelection(textSearch, this.textSelection.getText(), (OdfElement)newStartPoint, content.length() - 1);
                textSearch.setSelectedItem(selected);
            }
        }
        return this.tableContainer;
    }

    public TableSelection(TextSelection selection) {
        this.textSelection = selection;
        this.search = this.textSelection.getTextNavigation();
        this.tableContainer = null;
    }

    public void cut() throws InvalidNavigationException {
        this.textSelection.cut();
    }

    public void pasteAtEndOf(Selection positionItem) throws InvalidNavigationException {
        this.textSelection.pasteAtEndOf(positionItem);
    }

    private void delete(int fromIndex, int leftLength, Node pNode) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                fromIndex = 0;
                if (nextLength >= 0) {
                    buffer.append(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    leftLength = endLength - value.length();
                }
                node.setNodeValue(buffer.toString());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                leftLength -= nodeLength - fromIndex;
                fromIndex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromIndex = 0;
                --leftLength;
                continue;
            }
            this.delete(fromIndex, leftLength, node);
            int length = fromIndex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromIndex = 0;
        }
    }

    public void pasteAtFrontOf(Selection positionItem) throws InvalidNavigationException {
        this.textSelection.pasteAtFrontOf(positionItem);
    }

    protected void refresh(int offset) {
        this.textSelection.refresh(offset);
    }

    protected void refreshAfterFrontalDelete(Selection deletedItem) {
        this.textSelection.refreshAfterFrontalDelete(deletedItem);
    }

    protected void refreshAfterFrontalInsert(Selection insertedItem) {
        this.textSelection.refreshAfterFrontalInsert(insertedItem);
    }

    private void preparetableContainer(int leftLength, int index, boolean continued) {
        if (this.tableContainer == null) {
            String pos = "middle";
            OdfElement rightparentElement = this.textSelection.getContainerElement();
            int nodeLength = TextExtractor.getText(rightparentElement).length();
            if (index == 0) {
                if (leftLength == nodeLength) {
                    Paragraph orgparagraph = Paragraph.getInstanceof((TextParagraphElementBase)rightparentElement);
                    TextDocument document = (TextDocument)orgparagraph.getOwnerDocument();
                    this.tableContainer = document.insertTable(orgparagraph, this.sourceTable, false);
                    pos = "whole";
                    this.handlePageBreak(orgparagraph, pos, continued);
                    rightparentElement.getParentNode().removeChild((Node)rightparentElement);
                } else {
                    this.delete(index, leftLength, (Node)rightparentElement);
                    Paragraph orgparagraph = Paragraph.getInstanceof((TextParagraphElementBase)rightparentElement);
                    TextDocument document = (TextDocument)orgparagraph.getOwnerDocument();
                    this.tableContainer = document.insertTable(orgparagraph, this.sourceTable, true);
                    pos = "head";
                    this.handlePageBreak(orgparagraph, pos, continued);
                }
            } else if (nodeLength == index + leftLength) {
                this.delete(index, leftLength, (Node)rightparentElement);
                Paragraph orgparagraph = Paragraph.getInstanceof((TextParagraphElementBase)rightparentElement);
                TextDocument document = (TextDocument)orgparagraph.getOwnerDocument();
                this.tableContainer = document.insertTable(orgparagraph, this.sourceTable, false);
                this.handlePageBreak(orgparagraph, pos, continued);
            } else {
                this.delete(index, leftLength, (Node)rightparentElement);
                Node leftparentElement = rightparentElement.cloneNode(true);
                rightparentElement.getParentNode().insertBefore(leftparentElement, (Node)rightparentElement);
                nodeLength = TextExtractor.getText((OdfElement)leftparentElement).length();
                this.delete(index, nodeLength - index, leftparentElement);
                this.delete(0, index, (Node)rightparentElement);
                Paragraph orgparagraph = Paragraph.getInstanceof((TextParagraphElementBase)rightparentElement);
                TextDocument document = (TextDocument)orgparagraph.getOwnerDocument();
                this.tableContainer = document.insertTable(orgparagraph, this.sourceTable, true);
                if (!continued) {
                    this.textSelection.cleanBreakProperty(orgparagraph);
                }
            }
        } else {
            Table table;
            TextDocument document = (TextDocument)this.tableContainer.getOwnerDocument();
            TableTableElement newTEle = (TableTableElement)document.insertOdfElement((OdfElement)this.tableContainer.getOdfElement(), this.tableContainer.getOwnerDocument(), (OdfElement)this.sourceTable.getOdfElement(), true);
            this.tableContainer.getOdfElement().getParentNode().removeChild((Node)this.tableContainer.getOdfElement());
            this.tableContainer = table = Table.getInstance(newTEle);
        }
    }

    private Paragraph getLastParagraphInTable(Table table) {
        Paragraph paragraph = null;
        int rowCount = table.getRowCount();
        for (int i = rowCount - 1; i >= 0; --i) {
            Row row = table.getRowByIndex(i);
            int cellCount = row.getCellCount();
            for (int j = cellCount - 1; j >= 0; --j) {
                Cell cell = row.getCellByIndex(j);
                paragraph = cell.getParagraphByReverseIndex(0, false);
                if (paragraph == null) continue;
                return paragraph;
            }
        }
        return paragraph;
    }

    private TableProperties getTablePropertiesForWrite() {
        OdfStyleBase style = this.tableContainer.getStyleHandler().getStyleElementForRead();
        if (style == null || style.getLocalName().equals("default-style")) {
            OdfStyle element = this.tableContainer.getStyleHandler().getStyleElementForWrite();
            NodeList nodes = element.getChildNodes();
            int size = nodes.getLength();
            for (int i = 0; i < size; ++i) {
                element.removeChild(nodes.item(0));
            }
        }
        TableProperties properties = this.tableContainer.getStyleHandler().getTablePropertiesForWrite();
        return properties;
    }

    private OdfStyleBase getParagraphStyleElementForWrite() {
        OdfStyleBase style = this.tableContainer.getStyleHandler().getStyleElementForRead();
        OdfStyle element = this.tableContainer.getStyleHandler().getStyleElementForWrite();
        if (style == null || style.getLocalName().equals("default-style")) {
            NodeList nodes = element.getChildNodes();
            int size = nodes.getLength();
            for (int i = 0; i < size; ++i) {
                element.removeChild(nodes.item(0));
            }
        }
        return element;
    }

    private void handlePageBreak(Paragraph origParagraph, String pos, boolean continued) {
        String masterStyle;
        if (continued && this.textSelection.getTextNavigation().isHandlePageBreak()) {
            return;
        }
        ParagraphProperties orgParaPty = origParagraph.getStyleHandler().getParagraphPropertiesForRead();
        boolean handleBreak = false;
        String posInPara = "middle";
        if (continued && pos.equals("whole")) {
            posInPara = "end";
        } else if (continued && pos.endsWith("head")) {
            posInPara = "middle";
        } else if (continued && pos.endsWith("end")) {
            posInPara = "end";
        } else if (!continued && pos.endsWith("whole")) {
            posInPara = "whole";
        } else if (!continued && pos.endsWith("head")) {
            posInPara = "head";
        } else if (!continued && pos.endsWith("end")) {
            posInPara = "end";
        }
        if (orgParaPty != null) {
            String breakAttribute = orgParaPty.getBreakBefore();
            if (breakAttribute != null && (posInPara.equals("head") || posInPara.equals("whole"))) {
                this.getTablePropertiesForWrite().setBreak("before", breakAttribute);
                handleBreak = true;
            }
            if ((breakAttribute = orgParaPty.getBreakAfter()) != null && (posInPara.equals("end") || posInPara.equals("whole"))) {
                this.getTablePropertiesForWrite().setBreak("after", breakAttribute);
                handleBreak = true;
            }
        }
        if ((masterStyle = origParagraph.getStyleHandler().getStyleElementForRead().getOdfAttributeValue(OdfName.newName((NamespaceName)OdfDocumentNamespace.STYLE, (String)"master-page-name"))) != null && !masterStyle.isEmpty() && (posInPara.equals("head") || posInPara.equals("whole"))) {
            this.getParagraphStyleElementForWrite().setOdfAttributeValue(OdfName.newName((NamespaceName)OdfDocumentNamespace.STYLE, (String)"master-page-name"), masterStyle);
            handleBreak = true;
            try {
                int pageNumber = orgParaPty.getPageNumber();
                if (pos.equals("head")) {
                    this.tableContainer.getStyleHandler().getParagraphPropertiesForWrite().setPageNumber(pageNumber);
                }
            }
            catch (NumberFormatException e) {
                Logger.getLogger(ParagraphSelection.class.getName()).log(Level.SEVERE, e.getMessage(), "NumberFormatException");
            }
        }
        if (handleBreak && !posInPara.equals("whole")) {
            this.textSelection.cleanBreakProperty(origParagraph);
        }
    }

    TextSelection newTextSelection(Navigation search, String text, OdfElement containerElement, int index) {
        TextSelectionForTableReplacement selection = new TextSelectionForTableReplacement(search, text, containerElement, index);
        Selection.SelectionManager.registerItem(selection);
        return selection;
    }

    private class TextSelectionForTableReplacement
    extends TextSelection {
        private OdfElement mContainer;

        TextSelectionForTableReplacement(Navigation search, String text, OdfElement containerElement, int index) {
            super(search, text, containerElement, index);
            if (containerElement instanceof TableTableElement) {
                this.mContainer = containerElement;
            }
        }

        public OdfElement getContainerElement() {
            OdfElement element = super.getContainerElement();
            if (element == null) {
                element = this.mContainer;
            }
            return element;
        }
    }
}

