/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.osgi.framework.BundleContext;

public class KarafOsgiManager
extends OsgiManager {
    public static final String SUBJECT_RUN_AS = "karaf.subject.runas";

    public KarafOsgiManager(BundleContext bundleContext) {
        super(bundleContext);
    }

    public void service(final ServletRequest req, final ServletResponse res) throws ServletException, IOException {
        Object obj = req.getAttribute(SUBJECT_RUN_AS);
        if (obj instanceof Subject) {
            try {
                Subject.doAs((Subject)obj, new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        KarafOsgiManager.this.doService(req, res);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception cause = e.getException();
                if (cause instanceof ServletException) {
                    throw (ServletException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new ServletException((Throwable)cause);
            }
        } else {
            super.service(req, res);
        }
    }

    protected void doService(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }
}

