/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.PlainFormat;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.resultset.ResultSetApply;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sparql.util.TranslationTable;

public class ResultsFormat
extends Symbol {
    public static ResultsFormat FMT_RS_XML = new ResultsFormat("application/sparql-results+xml");
    public static ResultsFormat FMT_RS_JSON = new ResultsFormat("application/sparql-results+json");
    public static ResultsFormat FMT_RS_THRIFT = new ResultsFormat("application/sparql-results+thrift");
    public static ResultsFormat FMT_RS_CSV = new ResultsFormat("text/csv");
    public static ResultsFormat FMT_RS_TSV = new ResultsFormat("text/tab-separated-values");
    public static ResultsFormat FMT_RS_SSE = new ResultsFormat("text/sse");
    public static ResultsFormat FMT_NONE = new ResultsFormat("none");
    public static ResultsFormat FMT_TEXT = new ResultsFormat("text");
    public static ResultsFormat FMT_TUPLES = new ResultsFormat("tuples");
    public static ResultsFormat FMT_COUNT = new ResultsFormat("count");
    public static ResultsFormat FMT_RDF_XML = new ResultsFormat("application/rdf+xml");
    public static ResultsFormat FMT_RDF_N3 = new ResultsFormat("text/rdf+n3");
    public static ResultsFormat FMT_RDF_TTL = new ResultsFormat("text/turtle");
    public static ResultsFormat FMT_RDF_TURTLE = new ResultsFormat("text/turtle");
    public static ResultsFormat FMT_RDF_NT = new ResultsFormat("application/n-triples");
    public static ResultsFormat FMT_RDF_TRIG = new ResultsFormat("text/trig");
    public static ResultsFormat FMT_RDF_NQ = new ResultsFormat("application/n-quads");
    public static ResultsFormat FMT_UNKNOWN = new ResultsFormat("unknown");
    private static TranslationTable<ResultsFormat> names = new TranslationTable(true);
    static Map<ResultsFormat, Lang> mapResultsFormatToLang;

    private ResultsFormat(String symbol) {
        super(symbol);
    }

    public static ResultsFormat guessSyntax(String url) {
        return ResultsFormat.guessSyntax(url, FMT_RS_XML);
    }

    public static boolean isRDFGraphSyntax(ResultsFormat fmt) {
        if (FMT_RDF_N3.equals(fmt)) {
            return true;
        }
        if (FMT_RDF_TURTLE.equals(fmt)) {
            return true;
        }
        if (FMT_RDF_XML.equals(fmt)) {
            return true;
        }
        return FMT_RDF_NT.equals(fmt);
    }

    public static boolean isDatasetSyntax(ResultsFormat fmt) {
        if (FMT_RDF_TRIG.equals(fmt)) {
            return true;
        }
        return FMT_RDF_NQ.equals(fmt);
    }

    public static ResultsFormat guessSyntax(String url, ResultsFormat defaultFormat) {
        if (url.endsWith(".srx")) {
            return FMT_RS_XML;
        }
        if (url.endsWith(".xml")) {
            return FMT_RS_XML;
        }
        if (url.endsWith(".rdf")) {
            return FMT_RDF_XML;
        }
        if (url.endsWith(".n3")) {
            return FMT_RDF_N3;
        }
        if (url.endsWith(".ttl")) {
            return FMT_RDF_TURTLE;
        }
        if (url.endsWith(".srj")) {
            return FMT_RS_JSON;
        }
        if (url.endsWith(".json")) {
            return FMT_RS_JSON;
        }
        if (url.endsWith(".yml")) {
            return FMT_RS_JSON;
        }
        if (url.endsWith(".srt")) {
            return FMT_RS_THRIFT;
        }
        if (url.endsWith(".sse")) {
            return FMT_RS_SSE;
        }
        if (url.endsWith(".csv")) {
            return FMT_RS_CSV;
        }
        if (url.endsWith(".tsv")) {
            return FMT_RS_TSV;
        }
        if (url.endsWith(".trig")) {
            return FMT_RDF_TRIG;
        }
        if (url.endsWith(".nq")) {
            return FMT_RDF_NQ;
        }
        return defaultFormat;
    }

    public static ResultsFormat lookup(String s) {
        return names.lookup(s);
    }

    public static Lang convert(ResultsFormat fmt) {
        return mapResultsFormatToLang.get(fmt);
    }

    public static boolean oldWrite(OutputStream out, ResultsFormat outputFormat, Prologue prologue, ResultSet resultSet) {
        if (outputFormat.equals(FMT_COUNT)) {
            int count = ResultSetFormatter.consume(resultSet);
            PrintStream pOut = new PrintStream(out);
            pOut.println("Count = " + count);
            return true;
        }
        if (outputFormat.equals(FMT_RDF_XML)) {
            RDFOutput.outputAsRDF(out, "RDF/XML-ABBREV", resultSet);
            return true;
        }
        if (outputFormat.equals(FMT_RDF_TTL)) {
            RDFOutput.outputAsRDF(out, "TTL", resultSet);
            return true;
        }
        if (outputFormat.equals(FMT_RDF_NT)) {
            RDFOutput.outputAsRDF(out, "N-TRIPLES", resultSet);
            return true;
        }
        if (outputFormat.equals(FMT_TUPLES)) {
            PlainFormat pFmt = new PlainFormat(out, prologue);
            ResultSetApply a = new ResultSetApply(resultSet, pFmt);
            a.apply();
            return true;
        }
        return false;
    }

    static {
        names.put("srx", FMT_RS_XML);
        names.put("xml", FMT_RS_XML);
        names.put("json", FMT_RS_JSON);
        names.put("srj", FMT_RS_JSON);
        names.put("srt", FMT_RS_THRIFT);
        names.put("thrift", FMT_RS_THRIFT);
        names.put("sse", FMT_RS_SSE);
        names.put("csv", FMT_RS_CSV);
        names.put("tsv", FMT_RS_TSV);
        names.put("text", FMT_TEXT);
        names.put("count", FMT_COUNT);
        names.put("tuples", FMT_TUPLES);
        names.put("none", FMT_NONE);
        names.put("rdf", FMT_RDF_XML);
        names.put("rdf/n3", FMT_RDF_N3);
        names.put("rdf/xml", FMT_RDF_XML);
        names.put("n3", FMT_RDF_N3);
        names.put("ttl", FMT_RDF_TTL);
        names.put("turtle", FMT_RDF_TTL);
        names.put("graph", FMT_RDF_TTL);
        names.put("nt", FMT_RDF_NT);
        names.put("n-triples", FMT_RDF_NT);
        names.put("ntriples", FMT_RDF_NT);
        names.put("nq", FMT_RDF_NQ);
        names.put("nquads", FMT_RDF_NQ);
        names.put("n-quads", FMT_RDF_NQ);
        names.put("trig", FMT_RDF_TRIG);
        mapResultsFormatToLang = new HashMap<ResultsFormat, Lang>();
        mapResultsFormatToLang.put(FMT_NONE, ResultSetLang.SPARQLResultSetNone);
        mapResultsFormatToLang.put(FMT_RS_CSV, ResultSetLang.SPARQLResultSetCSV);
        mapResultsFormatToLang.put(FMT_RS_TSV, ResultSetLang.SPARQLResultSetTSV);
        mapResultsFormatToLang.put(FMT_RS_XML, ResultSetLang.SPARQLResultSetXML);
        mapResultsFormatToLang.put(FMT_RS_JSON, ResultSetLang.SPARQLResultSetJSON);
        mapResultsFormatToLang.put(FMT_RS_THRIFT, ResultSetLang.SPARQLResultSetThrift);
        mapResultsFormatToLang.put(FMT_TEXT, ResultSetLang.SPARQLResultSetText);
    }
}

