/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.POIDocument;
import org.apache.poi.hwpf.model.CHPBinTable;
import org.apache.poi.hwpf.model.CPSplitCalculator;
import org.apache.poi.hwpf.model.ComplexFileTable;
import org.apache.poi.hwpf.model.DocumentProperties;
import org.apache.poi.hwpf.model.EscherRecordHolder;
import org.apache.poi.hwpf.model.FSPATable;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.FontTable;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.ListTables;
import org.apache.poi.hwpf.model.PAPBinTable;
import org.apache.poi.hwpf.model.PicturesTable;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.SavedByTable;
import org.apache.poi.hwpf.model.SectionTable;
import org.apache.poi.hwpf.model.ShapesTable;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.hwpf.usermodel.HWPFList;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HWPFDocument
extends POIDocument {
    protected FileInformationBlock _fib;
    protected CPSplitCalculator _cpSplit;
    protected byte[] _mainStream;
    protected byte[] _tableStream;
    protected byte[] _dataStream;
    protected DocumentProperties _dop;
    protected ComplexFileTable _cft;
    protected TextPieceTable _tpt;
    protected CHPBinTable _cbt;
    protected PAPBinTable _pbt;
    protected SectionTable _st;
    protected StyleSheet _ss;
    protected FontTable _ft;
    protected ListTables _lt;
    protected SavedByTable _sbt;
    protected PicturesTable _pictures;
    protected FSPATable _fspa;
    protected EscherRecordHolder _dgg;
    protected ShapesTable _officeArts;

    protected HWPFDocument() {
        super(null, null);
    }

    public static POIFSFileSystem verifyAndBuildPOIFS(InputStream istream) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(istream, 6);
        byte[] first6 = new byte[6];
        pis.read(first6);
        if (first6[0] == 123 && first6[1] == 92 && first6[2] == 114 && first6[3] == 116 && first6[4] == 102) {
            throw new IllegalArgumentException("The document is really a RTF file");
        }
        pis.unread(first6);
        return new POIFSFileSystem(pis);
    }

    public HWPFDocument(InputStream istream) throws IOException {
        this(HWPFDocument.verifyAndBuildPOIFS(istream));
    }

    public HWPFDocument(POIFSFileSystem pfilesystem) throws IOException {
        this(pfilesystem.getRoot(), pfilesystem);
    }

    public HWPFDocument(DirectoryNode directory, POIFSFileSystem pfilesystem) throws IOException {
        super(directory, pfilesystem);
        DocumentEntry tableProps;
        this.readProperties();
        DocumentEntry documentProps = (DocumentEntry)directory.getEntry("WordDocument");
        this._mainStream = new byte[documentProps.getSize()];
        directory.createDocumentInputStream("WordDocument").read(this._mainStream);
        this._fib = new FileInformationBlock(this._mainStream);
        this._cpSplit = new CPSplitCalculator(this._fib);
        if (this._fib.isFEncrypted()) {
            throw new EncryptedDocumentException("Cannot process encrypted word files!");
        }
        String name = "0Table";
        if (this._fib.isFWhichTblStm()) {
            name = "1Table";
        }
        try {
            tableProps = (DocumentEntry)directory.getEntry(name);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalStateException("Table Stream '" + name + "' wasn't found - Either the document is corrupt, or is Word95 (or earlier)");
        }
        this._tableStream = new byte[tableProps.getSize()];
        directory.createDocumentInputStream(name).read(this._tableStream);
        this._fib.fillVariableFields(this._mainStream, this._tableStream);
        try {
            DocumentEntry dataProps = (DocumentEntry)directory.getEntry("Data");
            this._dataStream = new byte[dataProps.getSize()];
            this.filesystem.createDocumentInputStream("Data").read(this._dataStream);
        }
        catch (FileNotFoundException e) {
            this._dataStream = new byte[0];
        }
        int fcMin = 0;
        this._dop = new DocumentProperties(this._tableStream, this._fib.getFcDop());
        this._cft = new ComplexFileTable(this._mainStream, this._tableStream, this._fib.getFcClx(), fcMin);
        this._tpt = this._cft.getTextPieceTable();
        int cpMin = this._tpt.getCpMin();
        this._cbt = new CHPBinTable(this._mainStream, this._tableStream, this._fib.getFcPlcfbteChpx(), this._fib.getLcbPlcfbteChpx(), cpMin, this._tpt);
        this._pbt = new PAPBinTable(this._mainStream, this._tableStream, this._dataStream, this._fib.getFcPlcfbtePapx(), this._fib.getLcbPlcfbtePapx(), cpMin, this._tpt);
        this._fspa = new FSPATable(this._tableStream, this._fib.getFcPlcspaMom(), this._fib.getLcbPlcspaMom(), this.getTextTable().getTextPieces());
        this._dgg = this._fib.getFcDggInfo() != 0 ? new EscherRecordHolder(this._tableStream, this._fib.getFcDggInfo(), this._fib.getLcbDggInfo()) : new EscherRecordHolder();
        this._pictures = new PicturesTable(this, this._dataStream, this._mainStream, this._fspa, this._dgg);
        this._officeArts = new ShapesTable(this._tableStream, this._fib);
        this._st = new SectionTable(this._mainStream, this._tableStream, this._fib.getFcPlcfsed(), this._fib.getLcbPlcfsed(), fcMin, this._tpt, this._cpSplit);
        this._ss = new StyleSheet(this._tableStream, this._fib.getFcStshf());
        this._ft = new FontTable(this._tableStream, this._fib.getFcSttbfffn(), this._fib.getLcbSttbfffn());
        int listOffset = this._fib.getFcPlcfLst();
        int lfoOffset = this._fib.getFcPlfLfo();
        if (listOffset != 0 && this._fib.getLcbPlcfLst() != 0) {
            this._lt = new ListTables(this._tableStream, this._fib.getFcPlcfLst(), this._fib.getFcPlfLfo());
        }
        int sbtOffset = this._fib.getFcSttbSavedBy();
        int sbtLength = this._fib.getLcbSttbSavedBy();
        if (sbtOffset != 0 && sbtLength != 0) {
            this._sbt = new SavedByTable(this._tableStream, sbtOffset, sbtLength);
        }
        PlexOfCps plc = new PlexOfCps(this._tableStream, this._fib.getFcPlcffldMom(), this._fib.getLcbPlcffldMom(), 2);
        for (int x = 0; x < plc.length(); ++x) {
            GenericPropertyNode node = plc.getProperty(x);
            byte[] fld = node.getBytes();
            boolean breakpoint = false;
        }
    }

    public StyleSheet getStyleSheet() {
        return this._ss;
    }

    public FileInformationBlock getFileInformationBlock() {
        return this._fib;
    }

    public CPSplitCalculator getCPSplitCalculator() {
        return this._cpSplit;
    }

    public DocumentProperties getDocProperties() {
        return this._dop;
    }

    public Range getOverallRange() {
        List text = this._tpt.getTextPieces();
        PropertyNode p = (PropertyNode)text.get(text.size() - 1);
        return new Range(0, p.getEnd(), this);
    }

    public Range getRange() {
        this.getOverallRange();
        return new Range(this._cpSplit.getMainDocumentStart(), this._cpSplit.getMainDocumentEnd(), this);
    }

    public Range getFootnoteRange() {
        return new Range(this._cpSplit.getFootnoteStart(), this._cpSplit.getFootnoteEnd(), this);
    }

    public Range getHeaderStoryRange() {
        return new Range(this._cpSplit.getHeaderStoryStart(), this._cpSplit.getHeaderStoryEnd(), this);
    }

    public int characterLength() {
        List textPieces = this._tpt.getTextPieces();
        Iterator textIt = textPieces.iterator();
        int length = 0;
        while (textIt.hasNext()) {
            TextPiece tp = (TextPiece)textIt.next();
            length += tp.characterLength();
        }
        return length;
    }

    public ListTables getListTables() {
        return this._lt;
    }

    public SavedByTable getSavedByTable() {
        return this._sbt;
    }

    public PicturesTable getPicturesTable() {
        return this._pictures;
    }

    public ShapesTable getShapesTable() {
        return this._officeArts;
    }

    public void write(OutputStream out) throws IOException {
        byte[] dataBuf;
        HWPFFileSystem docSys = new HWPFFileSystem();
        HWPFOutputStream mainStream = docSys.getStream("WordDocument");
        HWPFOutputStream tableStream = docSys.getStream("1Table");
        int tableOffset = 0;
        this._fib.clearOffsetsSizes();
        int fibSize = this._fib.getSize();
        fibSize += 512 - fibSize % 512;
        byte[] placeHolder = new byte[fibSize];
        mainStream.write(placeHolder);
        int mainOffset = mainStream.getOffset();
        this._fib.setFcStshf(tableOffset);
        this._ss.writeTo(tableStream);
        this._fib.setLcbStshf(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        int fcMin = mainOffset;
        this._fib.setFcClx(tableOffset);
        this._cft.writeTo(docSys);
        this._fib.setLcbClx(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        int fcMac = mainStream.getOffset();
        this._fib.setFcPlcfbteChpx(tableOffset);
        this._cbt.writeTo(docSys, fcMin);
        this._fib.setLcbPlcfbteChpx(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        this._fib.setFcPlcfbtePapx(tableOffset);
        this._pbt.writeTo(docSys, fcMin);
        this._fib.setLcbPlcfbtePapx(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        this._fib.setFcPlcfsed(tableOffset);
        this._st.writeTo(docSys, fcMin);
        this._fib.setLcbPlcfsed(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        if (this._lt != null) {
            this._fib.setFcPlcfLst(tableOffset);
            this._lt.writeListDataTo(tableStream);
            this._fib.setLcbPlcfLst(tableStream.getOffset() - tableOffset);
            this._fib.setFcPlfLfo(tableStream.getOffset());
            this._lt.writeListOverridesTo(tableStream);
            this._fib.setLcbPlfLfo(tableStream.getOffset() - tableOffset);
            tableOffset = tableStream.getOffset();
        }
        if (this._sbt != null) {
            this._fib.setFcSttbSavedBy(tableOffset);
            this._sbt.writeTo(tableStream);
            this._fib.setLcbSttbSavedBy(tableStream.getOffset() - tableOffset);
            tableOffset = tableStream.getOffset();
        }
        this._fib.setFcSttbfffn(tableOffset);
        this._ft.writeTo(docSys);
        this._fib.setLcbSttbfffn(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        this._fib.setFcDop(tableOffset);
        byte[] buf = new byte[this._dop.getSize()];
        this._fib.setLcbDop(this._dop.getSize());
        this._dop.serialize(buf, 0);
        tableStream.write(buf);
        this._fib.setFcMin(fcMin);
        this._fib.setFcMac(fcMac);
        this._fib.setCbMac(mainStream.getOffset());
        byte[] mainBuf = mainStream.toByteArray();
        if (mainBuf.length < 4096) {
            byte[] tempBuf = new byte[4096];
            System.arraycopy(mainBuf, 0, tempBuf, 0, mainBuf.length);
            mainBuf = tempBuf;
        }
        this._fib.writeTo(mainBuf, tableStream);
        byte[] tableBuf = tableStream.toByteArray();
        if (tableBuf.length < 4096) {
            byte[] tempBuf = new byte[4096];
            System.arraycopy(tableBuf, 0, tempBuf, 0, tableBuf.length);
            tableBuf = tempBuf;
        }
        if ((dataBuf = this._dataStream) == null) {
            dataBuf = new byte[4096];
        }
        if (dataBuf.length < 4096) {
            byte[] tempBuf = new byte[4096];
            System.arraycopy(dataBuf, 0, tempBuf, 0, dataBuf.length);
            dataBuf = tempBuf;
        }
        POIFSFileSystem pfs = new POIFSFileSystem();
        pfs.createDocument(new ByteArrayInputStream(mainBuf), "WordDocument");
        pfs.createDocument(new ByteArrayInputStream(tableBuf), "1Table");
        pfs.createDocument(new ByteArrayInputStream(dataBuf), "Data");
        pfs.writeFilesystem(out);
    }

    public CHPBinTable getCharacterTable() {
        return this._cbt;
    }

    public PAPBinTable getParagraphTable() {
        return this._pbt;
    }

    public SectionTable getSectionTable() {
        return this._st;
    }

    public TextPieceTable getTextTable() {
        return this._cft.getTextPieceTable();
    }

    public byte[] getDataStream() {
        return this._dataStream;
    }

    public byte[] getTableStream() {
        return this._tableStream;
    }

    public int registerList(HWPFList list) {
        if (this._lt == null) {
            this._lt = new ListTables();
        }
        return this._lt.addList(list.getListData(), list.getOverride());
    }

    public FontTable getFontTable() {
        return this._ft;
    }

    public void delete(int start, int length) {
        Range r = new Range(start, start + length, this);
        r.delete();
    }

    public static void main(String[] args) {
        try {
            HWPFDocument doc = new HWPFDocument(new FileInputStream(args[0]));
            Range r = doc.getRange();
            String str = r.text();
            boolean x = false;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

