/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public abstract class TableFunctionEvaluator {
    protected transient StructObjectInspector OI;
    protected transient StructObjectInspector rawInputOI;
    protected PTFDesc.PartitionedTableFunctionDef tDef;
    protected PTFDesc ptfDesc;
    String partitionClass;
    int partitionMemSize;
    boolean transformsRawInput;
    protected transient PTFPartition outputPartition;

    public StructObjectInspector getOutputOI() {
        return this.OI;
    }

    protected void setOutputOI(StructObjectInspector outputOI) {
        this.OI = outputOI;
    }

    public PTFDesc.PartitionedTableFunctionDef getTableDef() {
        return this.tDef;
    }

    public void setTableDef(PTFDesc.PartitionedTableFunctionDef tDef) {
        this.tDef = tDef;
    }

    protected PTFDesc getQueryDef() {
        return this.ptfDesc;
    }

    protected void setQueryDef(PTFDesc ptfDesc) {
        this.ptfDesc = ptfDesc;
    }

    public String getPartitionClass() {
        return this.partitionClass;
    }

    public void setPartitionClass(String partitionClass) {
        this.partitionClass = partitionClass;
    }

    public int getPartitionMemSize() {
        return this.partitionMemSize;
    }

    public void setPartitionMemSize(int partitionMemSize) {
        this.partitionMemSize = partitionMemSize;
    }

    public StructObjectInspector getRawInputOI() {
        return this.rawInputOI;
    }

    protected void setRawInputOI(StructObjectInspector rawInputOI) {
        this.rawInputOI = rawInputOI;
    }

    public boolean isTransformsRawInput() {
        return this.transformsRawInput;
    }

    public void setTransformsRawInput(boolean transformsRawInput) {
        this.transformsRawInput = transformsRawInput;
    }

    public PTFPartition execute(PTFPartition iPart) throws HiveException {
        PTFPartition.PTFPartitionIterator<Object> pItr = iPart.iterator();
        PTFOperator.connectLeadLagFunctionsToPartition(this.ptfDesc, pItr);
        if (this.outputPartition == null) {
            this.outputPartition = new PTFPartition(this.getPartitionClass(), this.getPartitionMemSize(), this.tDef.getOutputShape().getSerde(), this.OI);
        } else {
            this.outputPartition.reset();
        }
        this.execute(pItr, this.outputPartition);
        return this.outputPartition;
    }

    protected abstract void execute(PTFPartition.PTFPartitionIterator<Object> var1, PTFPartition var2) throws HiveException;

    public PTFPartition transformRawInput(PTFPartition iPart) throws HiveException {
        if (!this.isTransformsRawInput()) {
            throw new HiveException(String.format("Internal Error: mapExecute called on function (%s)that has no Map Phase", this.tDef.getName()));
        }
        return this._transformRawInput(iPart);
    }

    protected PTFPartition _transformRawInput(PTFPartition iPart) throws HiveException {
        return null;
    }

    static {
        PTFUtils.makeTransient(TableFunctionEvaluator.class, "outputOI", "rawInputOI");
    }
}

