/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@UDFType(deterministic=true)
public abstract class GenericUDAFEvaluator
implements Closeable {
    Mode mode;

    public void configure(MapredContext mapredContext) {
    }

    public ObjectInspector init(Mode m, ObjectInspector[] parameters) throws HiveException {
        this.mode = m;
        return null;
    }

    public abstract AggregationBuffer getNewAggregationBuffer() throws HiveException;

    public abstract void reset(AggregationBuffer var1) throws HiveException;

    @Override
    public void close() throws IOException {
    }

    public void aggregate(AggregationBuffer agg, Object[] parameters) throws HiveException {
        if (this.mode == Mode.PARTIAL1 || this.mode == Mode.COMPLETE) {
            this.iterate(agg, parameters);
        } else {
            assert (parameters.length == 1);
            this.merge(agg, parameters[0]);
        }
    }

    public Object evaluate(AggregationBuffer agg) throws HiveException {
        if (this.mode == Mode.PARTIAL1 || this.mode == Mode.PARTIAL2) {
            return this.terminatePartial(agg);
        }
        return this.terminate(agg);
    }

    public abstract void iterate(AggregationBuffer var1, Object[] var2) throws HiveException;

    public abstract Object terminatePartial(AggregationBuffer var1) throws HiveException;

    public abstract void merge(AggregationBuffer var1, Object var2) throws HiveException;

    public abstract Object terminate(AggregationBuffer var1) throws HiveException;

    public static interface AggregationBuffer {
    }

    public static enum Mode {
        PARTIAL1,
        PARTIAL2,
        FINAL,
        COMPLETE;

    }
}

