/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

@Explain(displayName="TableScan")
public class TableScanDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private String alias;
    private List<VirtualColumn> virtualCols;
    private String statsAggKeyPrefix;
    private List<String> partColumns;
    private int rowLimit = -1;
    private boolean gatherStats;
    private boolean statsReliable;
    private int maxStatsKeyPrefixLength = -1;
    private ExprNodeDesc filterExpr;
    public static final String FILTER_EXPR_CONF_STR = "hive.io.filter.expr.serialized";
    public static final String FILTER_TEXT_CONF_STR = "hive.io.filter.text";
    private Map<String, Integer> bucketFileNameMapping;

    public TableScanDesc() {
    }

    public TableScanDesc(String alias) {
        this.alias = alias;
    }

    public TableScanDesc(String alias, List<VirtualColumn> vcs) {
        this.alias = alias;
        this.virtualCols = vcs;
    }

    @Override
    public Object clone() {
        ArrayList<VirtualColumn> vcs = new ArrayList<VirtualColumn>(this.getVirtualCols());
        return new TableScanDesc(this.getAlias(), vcs);
    }

    @Explain(displayName="alias")
    public String getAlias() {
        return this.alias;
    }

    @Explain(displayName="filterExpr")
    public ExprNodeDesc getFilterExpr() {
        return this.filterExpr;
    }

    public void setFilterExpr(ExprNodeDesc filterExpr) {
        this.filterExpr = filterExpr;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPartColumns(List<String> partColumns) {
        this.partColumns = partColumns;
    }

    public List<String> getPartColumns() {
        return this.partColumns;
    }

    public void setGatherStats(boolean gatherStats) {
        this.gatherStats = gatherStats;
    }

    @Explain(displayName="GatherStats", normalExplain=false)
    public boolean isGatherStats() {
        return this.gatherStats;
    }

    public List<VirtualColumn> getVirtualCols() {
        return this.virtualCols;
    }

    public void setVirtualCols(List<VirtualColumn> virtualCols) {
        this.virtualCols = virtualCols;
    }

    public void addVirtualCols(List<VirtualColumn> virtualCols) {
        this.virtualCols.addAll(virtualCols);
    }

    public void setStatsAggPrefix(String k) {
        this.statsAggKeyPrefix = k;
    }

    @Explain(displayName="Statistics Aggregation Key Prefix", normalExplain=false)
    public String getStatsAggPrefix() {
        return this.statsAggKeyPrefix;
    }

    public boolean isStatsReliable() {
        return this.statsReliable;
    }

    public void setStatsReliable(boolean statsReliable) {
        this.statsReliable = statsReliable;
    }

    public int getMaxStatsKeyPrefixLength() {
        return this.maxStatsKeyPrefixLength;
    }

    public void setMaxStatsKeyPrefixLength(int maxStatsKeyPrefixLength) {
        this.maxStatsKeyPrefixLength = maxStatsKeyPrefixLength;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    @Explain(displayName="Row Limit Per Split")
    public Integer getRowLimitExplain() {
        return this.rowLimit >= 0 ? Integer.valueOf(this.rowLimit) : null;
    }

    public Map<String, Integer> getBucketFileNameMapping() {
        return this.bucketFileNameMapping;
    }

    public void setBucketFileNameMapping(Map<String, Integer> bucketFileNameMapping) {
        this.bucketFileNameMapping = bucketFileNameMapping;
    }
}

