/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getToken().getType()));
        switch (tree.getToken().getType()) {
            case 622: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 665: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 624: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 648: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 557: 
            case 559: 
            case 560: 
            case 564: 
            case 565: 
            case 566: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 575: 
            case 577: 
            case 578: 
            case 579: 
            case 588: 
            case 590: 
            case 592: 
            case 605: 
            case 606: 
            case 607: 
            case 613: 
            case 615: 
            case 616: 
            case 617: 
            case 618: 
            case 619: 
            case 620: 
            case 633: 
            case 634: 
            case 667: 
            case 670: 
            case 722: 
            case 723: 
            case 734: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 739: 
            case 740: 
            case 741: 
            case 742: 
            case 743: 
            case 744: 
            case 745: 
            case 758: 
            case 801: 
            case 805: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 563: {
                HiveOperation commandType = null;
                Integer type = ((ASTNode)tree.getChild(1)).getToken().getType();
                commandType = tree.getChild(0).getChildCount() > 1 ? tablePartitionCommandType.get(type)[1] : tablePartitionCommandType.get(type)[0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 589: 
            case 614: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 580: {
                return new ColumnStatsSemanticAnalyzer(conf, tree);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(622, HiveOperation.EXPLAIN);
        commandType.put(665, HiveOperation.LOAD);
        commandType.put(624, HiveOperation.EXPORT);
        commandType.put(648, HiveOperation.IMPORT);
        commandType.put(588, HiveOperation.CREATEDATABASE);
        commandType.put(613, HiveOperation.DROPDATABASE);
        commandType.put(758, HiveOperation.SWITCHDATABASE);
        commandType.put(593, HiveOperation.CREATETABLE);
        commandType.put(801, HiveOperation.TRUNCATETABLE);
        commandType.put(617, HiveOperation.DROPTABLE);
        commandType.put(607, HiveOperation.DESCTABLE);
        commandType.put(606, HiveOperation.DESCFUNCTION);
        commandType.put(670, HiveOperation.MSCK);
        commandType.put(552, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(568, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(566, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(565, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(560, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(553, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(572, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(557, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(573, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(564, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(618, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(735, HiveOperation.SHOWDATABASES);
        commandType.put(740, HiveOperation.SHOWTABLES);
        commandType.put(734, HiveOperation.SHOWCOLUMNS);
        commandType.put(744, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(745, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(741, HiveOperation.SHOW_CREATETABLE);
        commandType.put(736, HiveOperation.SHOWFUNCTIONS);
        commandType.put(737, HiveOperation.SHOWINDEXES);
        commandType.put(739, HiveOperation.SHOWPARTITIONS);
        commandType.put(738, HiveOperation.SHOWLOCKS);
        commandType.put(589, HiveOperation.CREATEFUNCTION);
        commandType.put(614, HiveOperation.DROPFUNCTION);
        commandType.put(594, HiveOperation.CREATEVIEW);
        commandType.put(619, HiveOperation.DROPVIEW);
        commandType.put(590, HiveOperation.CREATEINDEX);
        commandType.put(615, HiveOperation.DROPINDEX);
        commandType.put(551, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(550, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(578, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(620, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(575, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(577, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(717, HiveOperation.QUERY);
        commandType.put(667, HiveOperation.LOCKTABLE);
        commandType.put(805, HiveOperation.UNLOCKTABLE);
        commandType.put(592, HiveOperation.CREATEROLE);
        commandType.put(616, HiveOperation.DROPROLE);
        commandType.put(633, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(722, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(742, HiveOperation.SHOW_GRANT);
        commandType.put(634, HiveOperation.GRANT_ROLE);
        commandType.put(723, HiveOperation.REVOKE_ROLE);
        commandType.put(743, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(549, HiveOperation.ALTERDATABASE);
        commandType.put(605, HiveOperation.DESCDATABASE);
        commandType.put(571, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(580, HiveOperation.ANALYZE_TABLE);
        tablePartitionCommandType.put(556, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(561, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(562, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(555, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(570, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(569, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(567, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(574, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(767, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(559, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
    }
}

