/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.ListSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.util.StringUtils;

public class SimpleFetchOptimizer
implements Transform {
    private final Log LOG = LogFactory.getLog((String)SimpleFetchOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        HashMap<String, Operator<? extends OperatorDesc>> topOps = pctx.getTopOps();
        if (pctx.getQB().isSimpleSelectQuery() && topOps.size() == 1) {
            String alias = (String)pctx.getTopOps().keySet().toArray()[0];
            Operator topOp = (Operator)pctx.getTopOps().values().toArray()[0];
            if (topOp instanceof TableScanOperator) {
                try {
                    FetchTask fetchTask = this.optimize(pctx, alias, (TableScanOperator)topOp);
                    if (fetchTask != null) {
                        pctx.setFetchTask(fetchTask);
                    }
                }
                catch (HiveException e) {
                    this.LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                    if (e instanceof SemanticException) {
                        throw (SemanticException)e;
                    }
                    throw new SemanticException(e.getMessage(), e);
                }
            }
        }
        return pctx;
    }

    private FetchTask optimize(ParseContext pctx, String alias, TableScanOperator source) throws HiveException {
        String mode = HiveConf.getVar(pctx.getConf(), HiveConf.ConfVars.HIVEFETCHTASKCONVERSION);
        boolean aggressive = "more".equals(mode);
        FetchData fetch = this.checkTree(aggressive, pctx, alias, source);
        if (fetch != null) {
            int limit = pctx.getQB().getParseInfo().getOuterQueryLimit();
            FetchWork fetchWork = fetch.convertToWork();
            FetchTask fetchTask = (FetchTask)TaskFactory.get(fetchWork, pctx.getConf(), new Task[0]);
            fetchWork.setSink(fetch.completed(pctx, fetchWork));
            fetchWork.setSource(source);
            fetchWork.setLimit(limit);
            return fetchTask;
        }
        return null;
    }

    private FetchData checkTree(boolean aggressive, ParseContext pctx, String alias, TableScanOperator ts) throws HiveException {
        SplitSample splitSample = pctx.getNameToSplitSample().get(alias);
        if (!aggressive && splitSample != null) {
            return null;
        }
        QB qb = pctx.getQB();
        if (!aggressive && qb.hasTableSample(alias)) {
            return null;
        }
        Table table = qb.getMetaData().getAliasToTable().get(alias);
        if (table == null) {
            return null;
        }
        if (!table.isPartitioned()) {
            return this.checkOperators(new FetchData(table, splitSample), ts, aggressive, false);
        }
        boolean bypassFilter = false;
        if (HiveConf.getBoolVar(pctx.getConf(), HiveConf.ConfVars.HIVEOPTPPD)) {
            ExprNodeDesc pruner = pctx.getOpToPartPruner().get(ts);
            bypassFilter = PartitionPruner.onlyContainsPartnCols(table, pruner);
        }
        if (aggressive || bypassFilter) {
            PrunedPartitionList pruned = pctx.getPrunedPartitions(alias, ts);
            if (aggressive || pruned.getUnknownPartns().isEmpty()) {
                return this.checkOperators(new FetchData(pruned, splitSample), ts, aggressive, bypassFilter &= pruned.getUnknownPartns().isEmpty());
            }
        }
        return null;
    }

    private FetchData checkOperators(FetchData fetch, TableScanOperator ts, boolean aggresive, boolean bypassFilter) {
        if (ts.getChildOperators().size() != 1) {
            return null;
        }
        Operator<OperatorDesc> op = ts.getChildOperators().get(0);
        while (!(!aggresive ? !(op instanceof LimitOperator) && (!(op instanceof FilterOperator) || !bypassFilter) && (!(op instanceof SelectOperator) || !((SelectDesc)((SelectOperator)op).getConf()).isSelectStar()) : !(op instanceof LimitOperator) && !(op instanceof FilterOperator) && !(op instanceof SelectOperator))) {
            if (op.getChildOperators() == null || op.getChildOperators().size() != 1) {
                return null;
            }
            op = op.getChildOperators().get(0);
        }
        if (op instanceof FileSinkOperator) {
            fetch.fileSink = op;
            return fetch;
        }
        return null;
    }

    private class FetchData {
        private final Table table;
        private final SplitSample splitSample;
        private final PrunedPartitionList partsList;
        private final HashSet<ReadEntity> inputs = new HashSet();
        private Operator<?> fileSink;

        private FetchData(Table table, SplitSample splitSample) {
            this.table = table;
            this.partsList = null;
            this.splitSample = splitSample;
        }

        private FetchData(PrunedPartitionList partsList, SplitSample splitSample) {
            this.table = null;
            this.partsList = partsList;
            this.splitSample = splitSample;
        }

        private FetchWork convertToWork() throws HiveException {
            this.inputs.clear();
            if (this.table != null) {
                this.inputs.add(new ReadEntity(this.table));
                String path = this.table.getPath().toString();
                FetchWork work = new FetchWork(path, Utilities.getTableDesc(this.table));
                PlanUtils.configureInputJobPropertiesForStorageHandler(work.getTblDesc());
                work.setSplitSample(this.splitSample);
                return work;
            }
            ArrayList<String> listP = new ArrayList<String>();
            ArrayList<PartitionDesc> partP = new ArrayList<PartitionDesc>();
            for (Partition partition : this.partsList.getNotDeniedPartns()) {
                this.inputs.add(new ReadEntity(partition));
                listP.add(partition.getPartitionPath().toString());
                partP.add(Utilities.getPartitionDesc(partition));
            }
            Table sourceTable = this.partsList.getSourceTable();
            this.inputs.add(new ReadEntity(sourceTable));
            TableDesc table = Utilities.getTableDesc(sourceTable);
            FetchWork work = new FetchWork(listP, partP, table);
            if (!work.getPartDesc().isEmpty()) {
                PartitionDesc part0 = work.getPartDesc().get(0);
                PlanUtils.configureInputJobPropertiesForStorageHandler(part0.getTableDesc());
                work.setSplitSample(this.splitSample);
            }
            return work;
        }

        private ListSinkOperator completed(ParseContext pctx, FetchWork work) {
            pctx.getSemanticInputs().addAll(this.inputs);
            ListSinkOperator sink = new ListSinkOperator();
            sink.setConf(new ListSinkDesc(work.getSerializationNullFormat()));
            sink.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
            Operator<OperatorDesc> parent = this.fileSink.getParentOperators().get(0);
            sink.getParentOperators().add(parent);
            parent.replaceChild(this.fileSink, sink);
            this.fileSink.setParentOperators(null);
            return sink;
        }
    }
}

