/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.BucketMapJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.BucketingSortingReduceSinkOptimizer;
import org.apache.hadoop.hive.ql.optimizer.ColumnPruner;
import org.apache.hadoop.hive.ql.optimizer.GlobalLimitOptimizer;
import org.apache.hadoop.hive.ql.optimizer.GroupByOptimizer;
import org.apache.hadoop.hive.ql.optimizer.JoinReorder;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.NonBlockingOpDeDupProc;
import org.apache.hadoop.hive.ql.optimizer.ReduceSinkDeDuplication;
import org.apache.hadoop.hive.ql.optimizer.SamplePruner;
import org.apache.hadoop.hive.ql.optimizer.SimpleFetchOptimizer;
import org.apache.hadoop.hive.ql.optimizer.SkewJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.SortedMergeBucketMapJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteGBUsingIndex;
import org.apache.hadoop.hive.ql.optimizer.lineage.Generator;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPruner;
import org.apache.hadoop.hive.ql.optimizer.pcr.PartitionConditionRemover;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcessor;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.ppd.PredicatePushDown;
import org.apache.hadoop.hive.ql.ppd.PredicateTransitivePropagate;

public class Optimizer {
    private ParseContext pctx;
    private List<Transform> transformations;

    public void initialize(HiveConf hiveConf) {
        this.transformations = new ArrayList<Transform>();
        this.transformations.add(new Generator());
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTPPD)) {
            this.transformations.add(new PredicateTransitivePropagate());
            this.transformations.add(new PredicatePushDown());
            this.transformations.add(new PartitionPruner());
            this.transformations.add(new PartitionConditionRemover());
            if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTLISTBUCKETING)) {
                this.transformations.add(new ListBucketingPruner());
            }
        }
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTCP)) {
            this.transformations.add(new ColumnPruner());
        }
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVE_OPTIMIZE_SKEWJOIN_COMPILETIME)) {
            this.transformations.add(new SkewJoinOptimizer());
        }
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTGBYUSINGINDEX)) {
            this.transformations.add(new RewriteGBUsingIndex());
        }
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTGROUPBY) || HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVE_MAP_GROUPBY_SORT)) {
            this.transformations.add(new GroupByOptimizer());
        }
        this.transformations.add(new SamplePruner());
        this.transformations.add(new MapJoinProcessor());
        boolean bucketMapJoinOptimizer = false;
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTBUCKETMAPJOIN)) {
            this.transformations.add(new BucketMapJoinOptimizer());
            bucketMapJoinOptimizer = true;
        }
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTSORTMERGEBUCKETMAPJOIN)) {
            if (!bucketMapJoinOptimizer) {
                this.transformations.add(new BucketMapJoinOptimizer());
            }
            this.transformations.add(new SortedMergeBucketMapJoinOptimizer());
        }
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTIMIZEBUCKETINGSORTING)) {
            this.transformations.add(new BucketingSortingReduceSinkOptimizer());
        }
        this.transformations.add(new UnionProcessor());
        this.transformations.add(new JoinReorder());
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATION)) {
            this.transformations.add(new ReduceSinkDeDuplication());
        }
        this.transformations.add(new NonBlockingOpDeDupProc());
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVELIMITOPTENABLE)) {
            this.transformations.add(new GlobalLimitOptimizer());
        }
        this.transformations.add(new SimpleFetchOptimizer());
    }

    public ParseContext optimize() throws SemanticException {
        for (Transform t : this.transformations) {
            this.pctx = t.transform(this.pctx);
        }
        return this.pctx;
    }

    public ParseContext getPctx() {
        return this.pctx;
    }

    public void setPctx(ParseContext pctx) {
        this.pctx = pctx;
    }
}

