/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;

abstract class InStream
extends InputStream {
    InStream() {
    }

    public abstract void seek(PositionProvider var1) throws IOException;

    public static InStream create(String name, ByteBuffer input, CompressionCodec codec, int bufferSize) throws IOException {
        if (codec == null) {
            return new UncompressedStream(name, input);
        }
        return new CompressedStream(name, input, codec, bufferSize);
    }

    private static class CompressedStream
    extends InStream {
        private final String name;
        private byte[] array;
        private final int bufferSize;
        private ByteBuffer uncompressed = null;
        private final CompressionCodec codec;
        private int offset;
        private final int base;
        private final int limit;
        private boolean isUncompressedOriginal;

        public CompressedStream(String name, ByteBuffer input, CompressionCodec codec, int bufferSize) {
            this.array = input.array();
            this.name = name;
            this.codec = codec;
            this.bufferSize = bufferSize;
            this.offset = this.base = input.arrayOffset() + input.position();
            this.limit = input.arrayOffset() + input.limit();
        }

        private void readHeader() throws IOException {
            if (this.limit - this.offset > 3) {
                int chunkLength = (0xFF & this.array[this.offset + 2]) << 15 | (0xFF & this.array[this.offset + 1]) << 7 | (0xFF & this.array[this.offset]) >> 1;
                if (chunkLength > this.bufferSize) {
                    throw new IllegalArgumentException("Buffer size too small. size = " + this.bufferSize + " needed = " + chunkLength);
                }
                boolean isOriginal = (this.array[this.offset] & 1) == 1;
                this.offset += 3;
                if (isOriginal) {
                    this.isUncompressedOriginal = true;
                    this.uncompressed = ByteBuffer.wrap(this.array, this.offset, chunkLength);
                } else {
                    if (this.isUncompressedOriginal) {
                        this.uncompressed = ByteBuffer.allocate(this.bufferSize);
                        this.isUncompressedOriginal = false;
                    } else if (this.uncompressed == null) {
                        this.uncompressed = ByteBuffer.allocate(this.bufferSize);
                    } else {
                        this.uncompressed.clear();
                    }
                    this.codec.decompress(ByteBuffer.wrap(this.array, this.offset, chunkLength), this.uncompressed);
                }
                this.offset += chunkLength;
            } else {
                throw new IllegalStateException("Can't read header");
            }
        }

        @Override
        public int read() throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.offset == this.limit) {
                    return -1;
                }
                this.readHeader();
            }
            return 0xFF & this.uncompressed.get();
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.offset == this.limit) {
                    return -1;
                }
                this.readHeader();
            }
            int actualLength = Math.min(length, this.uncompressed.remaining());
            System.arraycopy(this.uncompressed.array(), this.uncompressed.arrayOffset() + this.uncompressed.position(), data, offset, actualLength);
            this.uncompressed.position(this.uncompressed.position() + actualLength);
            return actualLength;
        }

        @Override
        public int available() throws IOException {
            if (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.offset == this.limit) {
                    return 0;
                }
                this.readHeader();
            }
            return this.uncompressed.remaining();
        }

        @Override
        public void close() {
            this.array = null;
            this.uncompressed = null;
            this.offset = 0;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.offset = this.base + (int)index.getNext();
            int uncompBytes = (int)index.getNext();
            if (uncompBytes != 0) {
                this.readHeader();
                this.uncompressed.position(this.uncompressed.position() + uncompBytes);
            } else if (this.uncompressed != null) {
                this.uncompressed.position(this.uncompressed.limit());
            }
        }

        public String toString() {
            return "compressed stream " + this.name + " base: " + this.base + " offset: " + this.offset + " limit: " + this.limit + (this.uncompressed == null ? "" : " uncompressed: " + this.uncompressed.position() + " to " + this.uncompressed.limit());
        }
    }

    private static class UncompressedStream
    extends InStream {
        private final String name;
        private byte[] array;
        private int offset;
        private final int base;
        private final int limit;

        public UncompressedStream(String name, ByteBuffer input) {
            this.name = name;
            this.array = input.array();
            this.offset = this.base = input.arrayOffset() + input.position();
            this.limit = input.arrayOffset() + input.limit();
        }

        @Override
        public int read() {
            if (this.offset == this.limit) {
                return -1;
            }
            return 0xFF & this.array[this.offset++];
        }

        @Override
        public int read(byte[] data, int offset, int length) {
            if (this.offset == this.limit) {
                return -1;
            }
            int actualLength = Math.min(length, this.limit - this.offset);
            System.arraycopy(this.array, this.offset, data, offset, actualLength);
            this.offset += actualLength;
            return actualLength;
        }

        @Override
        public int available() {
            return this.limit - this.offset;
        }

        @Override
        public void close() {
            this.array = null;
            this.offset = 0;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.offset = this.base + (int)index.getNext();
        }

        public String toString() {
            return "uncompressed stream " + this.name + " base: " + this.base + " offset: " + this.offset + " limit: " + this.limit;
        }
    }
}

