/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class HashMapWrapper<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private static final int THRESHOLD = 1000000;
    private static final float LOADFACTOR = 0.75f;
    private static final float MEMORYUSAGE = 1.0f;
    private float maxMemoryUsage;
    private HashMap<K, V> mHash;
    protected transient SessionState.LogHelper console;
    private File dumpFile;
    public static MemoryMXBean memoryMXBean;
    private long maxMemory;
    private long currentMemory;
    private NumberFormat num;

    public HashMapWrapper(int threshold, float loadFactor, float memoryUsage) {
        this.maxMemoryUsage = memoryUsage;
        this.mHash = new HashMap(threshold, loadFactor);
        memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.maxMemory = memoryMXBean.getHeapMemoryUsage().getMax();
        this.LOG.info((Object)("maximum memory: " + this.maxMemory));
        this.num = NumberFormat.getInstance();
        this.num.setMinimumFractionDigits(2);
    }

    public HashMapWrapper(int threshold) {
        this(threshold, 0.75f, 1.0f);
    }

    public HashMapWrapper() {
        this(1000000, 0.75f, 1.0f);
    }

    public V get(K key) {
        return this.mHash.get(key);
    }

    public boolean put(K key, V value) throws HiveException {
        this.mHash.put(key, value);
        return false;
    }

    public void remove(K key) {
        this.mHash.remove(key);
    }

    public long flushMemoryCacheToPersistent(File file) throws IOException {
        ObjectOutputStream outputStream = null;
        outputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file), 4096));
        outputStream.writeObject(this.mHash);
        outputStream.flush();
        outputStream.close();
        return file.length();
    }

    public void initilizePersistentHash(String fileName) throws IOException, ClassNotFoundException {
        ObjectInputStream inputStream = null;
        inputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName), 4096));
        HashMap hashtable = (HashMap)inputStream.readObject();
        this.setMHash(hashtable);
        inputStream.close();
    }

    public int size() {
        return this.mHash.size();
    }

    public Set<K> keySet() {
        return this.mHash.keySet();
    }

    public void close() throws HiveException {
        this.mHash.clear();
    }

    public void clear() throws HiveException {
        this.mHash.clear();
    }

    public int getKeySize() {
        return this.mHash.size();
    }

    public boolean isAbort(long numRows, SessionState.LogHelper console) {
        int size = this.mHash.size();
        long usedMemory = memoryMXBean.getHeapMemoryUsage().getUsed();
        double rate = (double)usedMemory / (double)this.maxMemory;
        console.printInfo(Utilities.now() + "\tProcessing rows:\t" + numRows + "\tHashtable size:\t" + size + "\tMemory usage:\t" + usedMemory + "\trate:\t" + this.num.format(rate));
        return rate > (double)this.maxMemoryUsage;
    }

    public void setLOG(Log log) {
        this.LOG = log;
    }

    public HashMap<K, V> getMHash() {
        return this.mHash;
    }

    public void setMHash(HashMap<K, V> hash) {
        this.mHash = hash;
    }

    public SessionState.LogHelper getConsole() {
        return this.console;
    }

    public void setConsole(SessionState.LogHelper console) {
        this.console = console;
    }

    public File getDumpFile() {
        return this.dumpFile;
    }

    public void setDumpFile(File dumpFile) {
        this.dumpFile = dumpFile;
    }

    public static MemoryMXBean getMemoryMXBean() {
        return memoryMXBean;
    }

    public static void setMemoryMXBean(MemoryMXBean memoryMXBean) {
        HashMapWrapper.memoryMXBean = memoryMXBean;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public long getCurrentMemory() {
        return this.currentMemory;
    }

    public void setCurrentMemory(long currentMemory) {
        this.currentMemory = currentMemory;
    }

    public NumberFormat getNum() {
        return this.num;
    }

    public void setNum(NumberFormat num) {
        this.num = num;
    }

    public static int getTHRESHOLD() {
        return 1000000;
    }
}

