/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.KeyWrapperFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PTFDeserializer;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeadLag;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class PTFOperator
extends Operator<PTFDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    PTFPartition inputPart;
    boolean isMapOperator;
    transient KeyWrapperFactory keyWrapperFactory;
    protected transient KeyWrapper currentKeys;
    protected transient KeyWrapper newKeys;
    transient HiveConf hiveConf;

    @Override
    protected void initializeOp(Configuration jobConf) throws HiveException {
        this.hiveConf = new HiveConf(jobConf, PTFOperator.class);
        Operator<OperatorDesc> parentOp = this.getParentOperators().get(0);
        this.isMapOperator = ((PTFDesc)this.conf).isMapSide();
        this.reconstructQueryDef(this.hiveConf);
        this.inputPart = this.createFirstPartitionForChain(this.inputObjInspectors[0], this.hiveConf, this.isMapOperator);
        if (this.isMapOperator) {
            PTFDesc.PartitionedTableFunctionDef tDef = ((PTFDesc)this.conf).getStartOfChain();
            this.outputObjInspector = tDef.getRawInputShape().getOI();
        } else {
            this.outputObjInspector = ((PTFDesc)this.conf).getFuncDef().getOutputShape().getOI();
        }
        this.setupKeysWrapper(this.inputObjInspectors[0]);
        super.initializeOp(jobConf);
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        super.closeOp(abort);
        if (this.inputPart.size() != 0) {
            if (this.isMapOperator) {
                this.processMapFunction();
            } else {
                this.processInputPartition();
            }
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (!this.isMapOperator) {
            boolean keysAreEqual;
            this.newKeys.getNewKey(row, this.inputPart.getOI());
            boolean bl = keysAreEqual = this.currentKeys != null && this.newKeys != null ? this.newKeys.equals(this.currentKeys) : false;
            if (this.currentKeys != null && !keysAreEqual) {
                this.processInputPartition();
                this.inputPart.reset();
            }
            if (this.currentKeys == null || !keysAreEqual) {
                if (this.currentKeys == null) {
                    this.currentKeys = this.newKeys.copyKey();
                } else {
                    this.currentKeys.copyKey(this.newKeys);
                }
            }
        }
        this.inputPart.append(row);
    }

    protected void reconstructQueryDef(HiveConf hiveConf) throws HiveException {
        PTFDeserializer dS = new PTFDeserializer((PTFDesc)this.conf, (StructObjectInspector)this.inputObjInspectors[0], hiveConf);
        dS.initializePTFChain(((PTFDesc)this.conf).getFuncDef());
    }

    protected void setupKeysWrapper(ObjectInspector inputOI) throws HiveException {
        PTFDesc.PartitionDef pDef = ((PTFDesc)this.conf).getStartOfChain().getPartition();
        ArrayList<PTFDesc.PTFExpressionDef> exprs = pDef.getExpressions();
        int numExprs = exprs.size();
        ExprNodeEvaluator[] keyFields = new ExprNodeEvaluator[numExprs];
        ObjectInspector[] keyOIs = new ObjectInspector[numExprs];
        ObjectInspector[] currentKeyOIs = new ObjectInspector[numExprs];
        for (int i = 0; i < numExprs; ++i) {
            PTFDesc.PTFExpressionDef exprDef = exprs.get(i);
            keyFields[i] = ExprNodeEvaluatorFactory.get(exprDef.getExprNode());
            keyOIs[i] = keyFields[i].initialize(inputOI);
            currentKeyOIs[i] = ObjectInspectorUtils.getStandardObjectInspector(keyOIs[i], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        this.keyWrapperFactory = new KeyWrapperFactory(keyFields, keyOIs, currentKeyOIs);
        this.newKeys = this.keyWrapperFactory.getKeyWrapper();
    }

    protected void processInputPartition() throws HiveException {
        PTFPartition outPart = this.executeChain(this.inputPart);
        if (((PTFDesc)this.conf).forWindowing()) {
            this.executeWindowExprs(outPart);
        } else {
            PTFPartition.PTFPartitionIterator<Object> pItr = outPart.iterator();
            while (pItr.hasNext()) {
                Object oRow = pItr.next();
                this.forward(oRow, this.outputObjInspector);
            }
        }
    }

    protected void processMapFunction() throws HiveException {
        PTFDesc.PartitionedTableFunctionDef tDef = ((PTFDesc)this.conf).getStartOfChain();
        PTFPartition outPart = tDef.getTFunction().transformRawInput(this.inputPart);
        PTFPartition.PTFPartitionIterator<Object> pItr = outPart.iterator();
        while (pItr.hasNext()) {
            Object oRow = pItr.next();
            this.forward(oRow, this.outputObjInspector);
        }
    }

    @Override
    public String getName() {
        return PTFOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "PTF";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.PTF;
    }

    private PTFPartition executeChain(PTFPartition part) throws HiveException {
        Stack<PTFDesc.PartitionedTableFunctionDef> fnDefs = new Stack<PTFDesc.PartitionedTableFunctionDef>();
        PTFDesc.PTFInputDef iDef = ((PTFDesc)this.conf).getFuncDef();
        while (iDef instanceof PTFDesc.PartitionedTableFunctionDef) {
            fnDefs.push((PTFDesc.PartitionedTableFunctionDef)iDef);
            iDef = iDef.getInput();
        }
        while (!fnDefs.isEmpty()) {
            PTFDesc.PartitionedTableFunctionDef currFnDef = (PTFDesc.PartitionedTableFunctionDef)fnDefs.pop();
            part = currFnDef.getTFunction().execute(part);
        }
        return part;
    }

    private void executeWindowExprs(PTFPartition oPart) throws HiveException {
        PTFDesc.WindowTableFunctionDef wTFnDef = (PTFDesc.WindowTableFunctionDef)((PTFDesc)this.conf).getFuncDef();
        StructObjectInspector inputOI = wTFnDef.getOutputFromWdwFnProcessing().getOI();
        StructObjectInspector outputOI = wTFnDef.getOutputShape().getOI();
        int numCols = outputOI.getAllStructFieldRefs().size();
        ArrayList<PTFDesc.WindowExpressionDef> wdwExprs = wTFnDef.getWindowExpressions();
        int numWdwExprs = wdwExprs == null ? 0 : wdwExprs.size();
        Object[] output = new Object[numCols];
        boolean forwardRowsUntouched = wdwExprs == null || wdwExprs.size() == 0;
        PTFPartition.PTFPartitionIterator<Object> pItr = oPart.iterator();
        PTFOperator.connectLeadLagFunctionsToPartition((PTFDesc)this.conf, pItr);
        while (pItr.hasNext()) {
            int colCnt = 0;
            Object oRow = pItr.next();
            if (forwardRowsUntouched) {
                this.forward(oRow, this.outputObjInspector);
                continue;
            }
            if (wdwExprs != null) {
                for (PTFDesc.WindowExpressionDef wdwExpr : wdwExprs) {
                    Object newCol = wdwExpr.getExprEvaluator().evaluate(oRow);
                    output[colCnt++] = newCol;
                }
            }
            while (colCnt < numCols) {
                StructField field = inputOI.getAllStructFieldRefs().get(colCnt - numWdwExprs);
                output[colCnt++] = ObjectInspectorUtils.copyToStandardObject(inputOI.getStructFieldData(oRow, field), field.getFieldObjectInspector());
            }
            this.forward(output, this.outputObjInspector);
        }
    }

    public PTFPartition createFirstPartitionForChain(ObjectInspector oi, HiveConf hiveConf, boolean isMapSide) throws HiveException {
        PTFDesc.PartitionedTableFunctionDef tabDef = ((PTFDesc)this.conf).getStartOfChain();
        TableFunctionEvaluator tEval = tabDef.getTFunction();
        String partClassName = tEval.getPartitionClass();
        int partMemSize = tEval.getPartitionMemSize();
        PTFPartition part = null;
        SerDe serde = isMapSide ? tabDef.getInput().getOutputShape().getSerde() : tabDef.getRawInputShape().getSerde();
        part = new PTFPartition(partClassName, partMemSize, serde, (StructObjectInspector)oi);
        return part;
    }

    public static void connectLeadLagFunctionsToPartition(PTFDesc ptfDesc, PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
        List<ExprNodeGenericFuncDesc> llFnDescs = ptfDesc.getLlInfo().getLeadLagExprs();
        if (llFnDescs == null) {
            return;
        }
        for (ExprNodeGenericFuncDesc llFnDesc : llFnDescs) {
            GenericUDFLeadLag llFn = (GenericUDFLeadLag)llFnDesc.getGenericUDF();
            llFn.setpItr(pItr);
        }
    }
}

