/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.service.HiveClient;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class CliSessionState
extends SessionState {
    public String database;
    public String execString;
    public String fileName;
    public Properties cmdProperties = new Properties();
    public List<String> initFiles = new ArrayList<String>();
    protected String host;
    protected int port;
    private boolean remoteMode = false;
    private TTransport transport;
    private HiveClient client;
    private Hive hive;

    public CliSessionState(HiveConf conf) {
        super(conf);
    }

    public void connect() throws TTransportException {
        this.transport = new TSocket(this.host, this.port);
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.client = new HiveClient((TProtocol)protocol);
        this.transport.open();
        this.remoteMode = true;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void close() {
        try {
            super.close();
            if (this.remoteMode) {
                this.client.clean();
                this.transport.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    public boolean isRemoteMode() {
        return this.remoteMode;
    }

    public HiveClient getClient() {
        return this.client;
    }

    public String getCurrentDbName() {
        if (this.hive == null) {
            try {
                this.hive = Hive.get((HiveConf)this.conf);
            }
            catch (HiveException e) {
                return null;
            }
        }
        return this.hive.getCurrentDatabase();
    }
}

