/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import com.yammer.metrics.stats.Snapshot;
import java.util.Random;
import org.apache.hadoop.hbase.metrics.histogram.MetricsHistogram;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.metrics.MetricsRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMetricsHistogram {
    @Test
    public void testBasicUniform() {
        MetricsHistogram h = new MetricsHistogram("testHistogram", null);
        for (int i = 0; i < 100; ++i) {
            h.update(i);
        }
        Assert.assertEquals((long)100L, (long)h.getCount());
        Assert.assertEquals((long)0L, (long)h.getMin());
        Assert.assertEquals((long)99L, (long)h.getMax());
        Assert.assertEquals((double)49.5, (double)h.getMean(), (double)0.01);
    }

    @Test
    public void testSnapshotPercentiles() {
        MetricsHistogram h = new MetricsHistogram("testHistogram", null);
        long[] data = this.genRandomData(h);
        Snapshot s = h.getSnapshot();
        this.assertPercentile(data, 50.0, s.getMedian());
        this.assertPercentile(data, 75.0, s.get75thPercentile());
        this.assertPercentile(data, 95.0, s.get95thPercentile());
        this.assertPercentile(data, 98.0, s.get98thPercentile());
        this.assertPercentile(data, 99.0, s.get99thPercentile());
        this.assertPercentile(data, 99.9, s.get999thPercentile());
    }

    @Test
    public void testPushMetric() {
        MetricsHistogram h = new MetricsHistogram("testHistogram", null);
        this.genRandomData(h);
        MetricsRecord mr = (MetricsRecord)Mockito.mock(MetricsRecord.class);
        h.pushMetric(mr);
        ((MetricsRecord)Mockito.verify((Object)mr)).setMetric("testHistogram_num_ops", 10000L);
        ((MetricsRecord)Mockito.verify((Object)mr)).setMetric((String)Matchers.eq((Object)"testHistogram_min"), Matchers.anyLong());
        ((MetricsRecord)Mockito.verify((Object)mr)).setMetric((String)Matchers.eq((Object)"testHistogram_max"), Matchers.anyLong());
        ((MetricsRecord)Mockito.verify((Object)mr)).setMetric((String)Matchers.eq((Object)"testHistogram_mean"), Matchers.anyFloat());
        ((MetricsRecord)Mockito.verify((Object)mr)).setMetric((String)Matchers.eq((Object)"testHistogram_std_dev"), Matchers.anyFloat());
        ((MetricsRecord)Mockito.verify((Object)mr)).setMetric((String)Matchers.eq((Object)"testHistogram_median"), Matchers.anyFloat());
        ((MetricsRecord)Mockito.verify((Object)mr)).setMetric((String)Matchers.eq((Object)"testHistogram_75th_percentile"), Matchers.anyFloat());
        ((MetricsRecord)Mockito.verify((Object)mr)).setMetric((String)Matchers.eq((Object)"testHistogram_95th_percentile"), Matchers.anyFloat());
        ((MetricsRecord)Mockito.verify((Object)mr)).setMetric((String)Matchers.eq((Object)"testHistogram_99th_percentile"), Matchers.anyFloat());
    }

    private void assertPercentile(long[] data, double percentile, double value) {
        int count = 0;
        for (long v : data) {
            if (!((double)v < value)) continue;
            ++count;
        }
        Assert.assertEquals((String)("Wrong " + percentile + " percentile"), (long)((int)(percentile / 100.0)), (long)(count / data.length));
    }

    private long[] genRandomData(MetricsHistogram h) {
        Random r = new Random();
        long[] data = new long[10000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (long)(r.nextGaussian() * 10000.0);
            h.update(data[i]);
        }
        return data;
    }
}

