/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;

public class TestMiniMRProxyUser
extends TestCase {
    private MiniDFSCluster dfsCluster = null;
    private MiniMRCluster mrCluster = null;

    protected void setUp() throws Exception {
        super.setUp();
        if (System.getProperty("hadoop.log.dir") == null) {
            System.setProperty("hadoop.log.dir", "/tmp");
        }
        int taskTrackers = 2;
        int dataNodes = 2;
        String proxyUser = System.getProperty("user.name");
        String proxyGroup = "g";
        StringBuilder sb = new StringBuilder();
        sb.append("127.0.0.1,localhost");
        for (InetAddress i : InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())) {
            sb.append(",").append(i.getCanonicalHostName());
        }
        JobConf conf = new JobConf();
        conf.set("dfs.block.access.token.enable", "false");
        conf.set("dfs.permissions", "true");
        conf.set("hadoop.security.authentication", "simple");
        conf.set("hadoop.proxyuser." + proxyUser + ".hosts", sb.toString());
        conf.set("hadoop.proxyuser." + proxyUser + ".groups", proxyGroup);
        String[] userGroups = new String[]{proxyGroup};
        UserGroupInformation.createUserForTesting((String)proxyUser, (String[])userGroups);
        UserGroupInformation.createUserForTesting((String)"u1", (String[])userGroups);
        UserGroupInformation.createUserForTesting((String)"u2", (String[])new String[]{"gg"});
        this.dfsCluster = new MiniDFSCluster((Configuration)conf, dataNodes, true, null);
        DistributedFileSystem fileSystem = this.dfsCluster.getFileSystem();
        fileSystem.mkdirs(new Path("/tmp"));
        fileSystem.mkdirs(new Path("/user"));
        fileSystem.mkdirs(new Path("/hadoop/mapred/system"));
        fileSystem.setPermission(new Path("/tmp"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fileSystem.setPermission(new Path("/user"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fileSystem.setPermission(new Path("/hadoop/mapred/system"), FsPermission.valueOf((String)"-rwx------"));
        String nnURI = fileSystem.getUri().toString();
        int numDirs = 1;
        String[] racks = null;
        String[] hosts = null;
        this.mrCluster = new MiniMRCluster(0, 0, taskTrackers, nnURI, numDirs, racks, hosts, null, conf);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
    }

    protected JobConf getJobConf() {
        return this.mrCluster.createJobConf();
    }

    protected void tearDown() throws Exception {
        if (this.mrCluster != null) {
            this.mrCluster.shutdown();
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
        super.tearDown();
    }

    private void mrRun() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getJobConf());
        Path inputDir = new Path("input");
        fs.mkdirs(inputDir);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
        writer.write("hello");
        ((Writer)writer).close();
        Path outputDir = new Path("output", "output");
        JobConf jobConf = new JobConf((Configuration)this.getJobConf());
        jobConf.setInt("mapred.map.tasks", 1);
        jobConf.setInt("mapred.map.max.attempts", 1);
        jobConf.setInt("mapred.reduce.max.attempts", 1);
        jobConf.set("mapred.input.dir", inputDir.toString());
        jobConf.set("mapred.output.dir", outputDir.toString());
        JobClient jobClient = new JobClient(jobConf);
        RunningJob runJob = jobClient.submitJob(jobConf);
        runJob.waitForCompletion();
        TestMiniMRProxyUser.assertTrue((boolean)runJob.isComplete());
        TestMiniMRProxyUser.assertTrue((boolean)runJob.isSuccessful());
    }

    public void __testCurrentUser() throws Exception {
        this.mrRun();
    }

    public void testValidProxyUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)"u1", (UserGroupInformation)UserGroupInformation.getLoginUser());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestMiniMRProxyUser.this.mrRun();
                return null;
            }
        });
    }

    public void ___testInvalidProxyUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)"u2", (UserGroupInformation)UserGroupInformation.getLoginUser());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    TestMiniMRProxyUser.this.mrRun();
                    Assert.fail();
                }
                catch (RemoteException ex) {
                }
                catch (Exception ex) {
                    Assert.fail();
                }
                return null;
            }
        });
    }
}

