/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.lifecycle;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;

public class PerRequestResourceProvider
implements ResourceProvider {
    private Constructor<?> c;
    private Method postConstructMethod;
    private Method preDestroyMethod;

    public PerRequestResourceProvider(Class<?> clazz) {
        this.c = ResourceUtils.findResourceConstructor(clazz, true);
        if (this.c == null) {
            throw new RuntimeException("Resource class " + clazz + " has no valid constructor");
        }
        this.postConstructMethod = ResourceUtils.findPostConstructMethod(clazz);
        this.preDestroyMethod = ResourceUtils.findPreDestroyMethod(clazz);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Object getInstance(Message m) {
        return this.createInstance(m);
    }

    protected Object createInstance(Message m) {
        Object[] values = ResourceUtils.createConstructorArguments(this.c, m);
        try {
            Object instance = values.length > 0 ? this.c.newInstance(values) : this.c.newInstance(new Object[0]);
            InjectionUtils.invokeLifeCycleMethod(instance, this.postConstructMethod);
            return instance;
        }
        catch (InstantiationException ex) {
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated";
            throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
        }
        catch (IllegalAccessException ex) {
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated" + " due to IllegalAccessException";
            throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
        }
        catch (InvocationTargetException ex) {
            String msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated" + " due to InvocationTargetException";
            throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
        }
    }

    @Override
    public void releaseInstance(Message m, Object o) {
        InjectionUtils.invokeLifeCycleMethod(o, this.preDestroyMethod);
    }

    @Override
    public Class<?> getResourceClass() {
        return this.c.getDeclaringClass();
    }
}

