/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.simple.generator;

import java.util.Map;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.java2wsdl.processor.internal.simple.generator.AbstractSimpleGenerator;

public class SimpleClientGenerator
extends AbstractSimpleGenerator {
    private static final String CLIENT_TEMPLATE = "org/apache/cxf/tools/java2wsdl/processor/internal/simple/generator/template/client.vm";

    public SimpleClientGenerator() {
        this.name = "clt.generator";
    }

    public boolean passthrough() {
        return !this.env.optionSet("client");
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        Map<String, JavaInterface> interfaces = javaModel.getInterfaces();
        for (JavaInterface intf : interfaces.values()) {
            this.clearAttributes();
            this.setAttributes("intf", intf);
            this.setAttributes("seiClass", this.env.get("seiClass"));
            this.setAttributes("address", this.env.get("address"));
            this.setCommonAttributes();
            this.doWrite(CLIENT_TEMPLATE, this.parseOutputName(intf.getPackageName(), intf.getName() + "Client"));
            this.env.put("clientClass", intf.getFullClassName() + "Client");
        }
    }
}

