/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.wsdl11.WSDLBindingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBindingFactory
implements BindingFactory,
WSDLBindingFactory {
    protected Collection<String> activationNamespaces;
    protected Bus bus;

    @PostConstruct
    void registerWithBindingManager() {
        BindingFactoryManager manager = this.bus.getExtension(BindingFactoryManager.class);
        for (String ns : this.activationNamespaces) {
            manager.registerBindingFactory(ns, this);
        }
    }

    public BindingInfo createBindingInfo(ServiceInfo service, String namespace, Object config) {
        return new BindingInfo(service, namespace);
    }

    @Override
    public BindingInfo createBindingInfo(Service service, String namespace, Object config) {
        BindingInfo bi = this.createBindingInfo(service.getServiceInfos().get(0), namespace, config);
        if (bi.getName() == null) {
            bi.setName(new QName(service.getName().getNamespaceURI(), service.getName().getLocalPart() + "Binding"));
        }
        return bi;
    }

    @Override
    public BindingInfo createBindingInfo(ServiceInfo service, Binding binding, String ns) {
        BindingInfo bi = this.createBindingInfo(service, ns, null);
        return this.initializeBindingInfo(service, binding, bi);
    }

    protected BindingInfo initializeBindingInfo(ServiceInfo service, Binding binding, BindingInfo bi) {
        bi.setName(binding.getQName());
        this.copyExtensors(bi, (ElementExtensible)binding, null);
        for (BindingOperation bop : CastUtils.cast(binding.getBindingOperations(), BindingOperation.class)) {
            String portTypeNs;
            QName opName;
            BindingOperationInfo bop2;
            String inName = null;
            String outName = null;
            if (bop.getBindingInput() != null) {
                inName = bop.getBindingInput().getName();
            }
            if (bop.getBindingOutput() != null) {
                outName = bop.getBindingOutput().getName();
            }
            if ((bop2 = bi.getOperation(opName = new QName(portTypeNs = binding.getPortType().getQName().getNamespaceURI(), bop.getName()))) == null && (bop2 = bi.buildOperation(opName, inName, outName)) != null) {
                bi.addOperation(bop2);
            }
            if (bop2 == null) continue;
            this.copyExtensors(bop2, (ElementExtensible)bop, bop2);
            if (bop.getBindingInput() != null) {
                this.copyExtensors(bop2.getInput(), (ElementExtensible)bop.getBindingInput(), bop2);
            }
            if (bop.getBindingOutput() != null) {
                this.copyExtensors(bop2.getOutput(), (ElementExtensible)bop.getBindingOutput(), bop2);
            }
            for (BindingFault f : CastUtils.cast(bop.getBindingFaults().values(), BindingFault.class)) {
                this.copyExtensors(bop2.getFault(new QName(service.getTargetNamespace(), f.getName())), (ElementExtensible)bop.getBindingFault(f.getName()), bop2);
            }
        }
        return bi;
    }

    private void copyExtensors(AbstractPropertiesHolder info, ElementExtensible extElement, BindingOperationInfo bop) {
        if (info != null) {
            for (ExtensibilityElement ext : CastUtils.cast(extElement.getExtensibilityElements(), ExtensibilityElement.class)) {
                info.addExtensor(ext);
                if (bop != null && extElement instanceof BindingInput) {
                    this.addMessageFromBinding(ext, bop, true);
                }
                if (bop == null || !(extElement instanceof BindingOutput)) continue;
                this.addMessageFromBinding(ext, bop, false);
            }
        }
    }

    protected void addMessageFromBinding(ExtensibilityElement ext, BindingOperationInfo bop, boolean isInput) {
    }

    @Override
    public void addListener(Destination d, Endpoint e) {
        ChainInitiationObserver observer = new ChainInitiationObserver(e, this.bus);
        d.setMessageObserver(observer);
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Collection<String> getActivationNamespaces() {
        return this.activationNamespaces;
    }

    @Resource(name="activationNamespaces")
    public void setActivationNamespaces(Collection<String> activationNamespaces) {
        this.activationNamespaces = activationNamespaces;
    }
}

