/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator;

import javax.servlet.ServletContext;
import org.apache.cocoon.spring.configurator.impl.ServletContextFactoryBean;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class WebAppContextUtils {
    public static final String CONTAINER_REQUEST_ATTRIBUTE = WebAppContextUtils.class.getName();

    public static WebApplicationContext getCurrentWebApplicationContext() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return WebAppContextUtils.getCurrentWebApplicationContext(attributes);
    }

    protected static WebApplicationContext getCurrentWebApplicationContext(RequestAttributes attributes) {
        Object obj;
        if (attributes != null && (obj = attributes.getAttribute(CONTAINER_REQUEST_ATTRIBUTE, 0)) != null) {
            return (WebApplicationContext)obj;
        }
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)ServletContextFactoryBean.getServletContext());
    }

    public static Object enteringContext(WebApplicationContext webAppContext) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        WebApplicationContext oldContext = (WebApplicationContext)attributes.getAttribute(CONTAINER_REQUEST_ATTRIBUTE, 0);
        attributes.setAttribute(CONTAINER_REQUEST_ATTRIBUTE, (Object)webAppContext, 0);
        Thread.currentThread().setContextClassLoader(webAppContext.getClassLoader());
        return new ContextInfo(oldContext, oldClassLoader);
    }

    public static void leavingContext(WebApplicationContext webAppContext, Object handle) {
        if (!(handle instanceof ContextInfo)) {
            throw new IllegalArgumentException("Handle must be an instance of ContextInfo and not " + handle);
        }
        ContextInfo info = (ContextInfo)handle;
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Thread.currentThread().setContextClassLoader(info.classLoader);
        if (info.webAppContext == null) {
            attributes.removeAttribute(CONTAINER_REQUEST_ATTRIBUTE, 0);
        } else {
            attributes.setAttribute(CONTAINER_REQUEST_ATTRIBUTE, (Object)info.webAppContext, 0);
        }
    }

    protected static final class ContextInfo {
        public final ClassLoader classLoader;
        public final WebApplicationContext webAppContext;

        public ContextInfo(WebApplicationContext w, ClassLoader c) {
            this.classLoader = c;
            this.webAppContext = w;
        }
    }
}

