/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.configuration;

import java.util.Iterator;
import java.util.Properties;
import org.apache.cocoon.configuration.Settings;

public class PropertyHelper {
    public static String replace(String value, Settings settings) {
        return PropertyHelper.replace(value, null, settings);
    }

    public static String replace(String value, Properties properties, Settings settings) {
        int pos;
        if (value == null || value.indexOf("${") == -1) {
            return value;
        }
        StringBuffer buffer = new StringBuffer();
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > prev) {
                buffer.append(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                buffer.append("$");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                buffer.append(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName == -1) {
                buffer.append(value.substring(pos));
                prev = value.length();
                continue;
            }
            String propertyName = value.substring(pos + 2, endName);
            String propertyValue = PropertyHelper.getProperty(propertyName, properties, settings);
            if (propertyValue == null) {
                buffer.append("${");
                buffer.append(propertyName);
                buffer.append('}');
            } else {
                buffer.append(propertyValue);
            }
            prev = endName + 1;
        }
        if (prev < value.length()) {
            buffer.append(value.substring(prev));
        }
        return buffer.toString();
    }

    public static String getProperty(String key, Properties properties, Settings settings) {
        String defaultValue;
        String name;
        int pos = key.indexOf(58);
        if (pos != -1) {
            name = key.substring(0, pos);
            defaultValue = key.substring(pos + 1);
        } else {
            name = key;
            defaultValue = null;
        }
        String value = null;
        if (properties != null) {
            value = properties.getProperty(name);
        }
        if (value == null && settings != null) {
            value = settings.getProperty(name);
        }
        if (value == null) {
            try {
                value = System.getProperty(name);
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static void replaceAll(Properties props, Settings settings) {
        Iterator<Object> kI = props.keySet().iterator();
        while (kI.hasNext()) {
            String key = (String)kI.next();
            String value = props.getProperty(key);
            value = PropertyHelper.replace(value, props, settings);
            props.put(key, value);
        }
    }
}

