/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XMLUtils.class);
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY;

    public static XMLStreamWriter createWriter(OutputStream out) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(out, "UTF-8");
    }

    public static void startXmlDocument(XMLStreamWriter writer) throws XMLStreamException {
        writer.setPrefix("atom", "http://www.w3.org/2005/Atom");
        writer.setPrefix("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        writer.setPrefix("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        writer.setPrefix("chemistry", "http://chemistry.apache.org/");
        writer.writeStartDocument();
    }

    public static void endXmlDocument(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndDocument();
        writer.close();
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, String value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        if (namespace == null) {
            writer.writeStartElement(tag);
        } else {
            writer.writeStartElement(prefix, tag, namespace);
        }
        writer.writeCharacters(value);
        writer.writeEndElement();
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, BigInteger value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, value.toString());
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, BigDecimal value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, value.toString());
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, GregorianCalendar value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, DateTimeHelper.formatXmlDateTime(value));
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, Boolean value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, value != false ? "true" : "false");
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, Enum<?> value) throws XMLStreamException {
        Object enumValue;
        if (value == null) {
            return;
        }
        try {
            enumValue = value.getClass().getMethod("value", new Class[0]).invoke(value, new Object[0]);
        }
        catch (Exception e) {
            throw new XMLStreamException("Cannot get enum value", e);
        }
        XMLUtils.write(writer, prefix, namespace, tag, enumValue.toString());
    }

    public static XMLStreamReader createParser(InputStream stream) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(stream);
    }

    public static boolean next(XMLStreamReader parser) throws XMLStreamException {
        if (parser.hasNext()) {
            try {
                parser.next();
            }
            catch (XMLStreamException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static void skip(XMLStreamReader parser) throws XMLStreamException {
        int level = 1;
        while (XMLUtils.next(parser)) {
            int event = parser.getEventType();
            if (event == 1) {
                ++level;
                continue;
            }
            if (event != 2 || --level != 0) continue;
            break;
        }
        XMLUtils.next(parser);
    }

    public static boolean findNextStartElemenet(XMLStreamReader parser) throws XMLStreamException {
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                return true;
            }
            if (!parser.hasNext()) break;
            parser.next();
        }
        return false;
    }

    public static String readText(XMLStreamReader parser, int maxLength) throws XMLStreamException {
        int event;
        StringBuilder sb = new StringBuilder();
        XMLUtils.next(parser);
        while ((event = parser.getEventType()) != 2) {
            if (event == 4 || event == 12) {
                int len = parser.getTextLength();
                if (len > 0) {
                    if (sb.length() + len > maxLength) {
                        throw new CmisInvalidArgumentException("String limit exceeded!");
                    }
                    char[] chars = parser.getTextCharacters();
                    int offset = parser.getTextStart();
                    sb.append(chars, offset, len);
                }
            } else if (event == 1) {
                throw new RuntimeException("Unexpected tag: " + parser.getName());
            }
            if (XMLUtils.next(parser)) continue;
            break;
        }
        XMLUtils.next(parser);
        return sb.toString();
    }

    private static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        factory.setExpandEntityReferences(false);
        factory.setCoalescing(false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory.newDocumentBuilder();
    }

    public static Document newDomDocument() throws ParserConfigurationException {
        return XMLUtils.newDocumentBuilder().newDocument();
    }

    public static Document parseDomDocument(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.newDocumentBuilder().parse(stream);
    }

    static {
        try {
            XML_INPUT_FACTORY.setProperty("reuse-instance", Boolean.FALSE);
            LOG.warn("You are using an unsupported StAX parser.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
        try {
            XML_OUTPUT_FACTORY.setProperty("reuse-instance", Boolean.FALSE);
            LOG.warn("You are using an unsupported StAX parser.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        XML_OUTPUT_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
    }
}

