/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.cassandra.auth.AuthCacheMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="setauthcacheconfig", description="Set configuration for Auth cache")
public class SetAuthCacheConfig
extends NodeTool.NodeToolCmd {
    @Option(title="cache-name", name={"--cache-name"}, description="Name of Auth cache (required)", required=true)
    private String cacheName;
    @Option(title="validity-period", name={"--validity-period"}, description="Validity period in milliseconds")
    private Integer validityPeriod;
    @Option(title="update-interval", name={"--update-interval"}, description="Update interval in milliseconds")
    private Integer updateInterval;
    @Option(title="max-entries", name={"--max-entries"}, description="Max entries")
    private Integer maxEntries;
    @Option(title="enable-active-update", name={"--enable-active-update"}, description="Enable active update")
    private Boolean enableActiveUpdate;
    @Option(title="disable-active-update", name={"--disable-active-update"}, description="Disable active update")
    private Boolean disableActiveUpdate;

    @Override
    public void execute(NodeProbe probe) {
        Boolean activeUpdate = this.getActiveUpdate(this.enableActiveUpdate, this.disableActiveUpdate);
        Preconditions.checkArgument((this.validityPeriod != null || this.updateInterval != null || this.maxEntries != null || activeUpdate != null ? 1 : 0) != 0, (Object)"At least one optional parameter need to be passed");
        AuthCacheMBean authCacheMBean = probe.getAuthCacheMBean(this.cacheName);
        if (this.validityPeriod != null) {
            authCacheMBean.setValidity(this.validityPeriod);
            probe.output().out.println("Changed Validity Period to " + this.validityPeriod);
        }
        if (this.updateInterval != null) {
            authCacheMBean.setUpdateInterval(this.updateInterval);
            probe.output().out.println("Changed Update Interval to " + this.updateInterval);
        }
        if (this.maxEntries != null) {
            authCacheMBean.setMaxEntries(this.maxEntries);
            probe.output().out.println("Changed Max Entries to " + this.maxEntries);
        }
        if (activeUpdate != null) {
            authCacheMBean.setActiveUpdate(activeUpdate);
            probe.output().out.println("Changed Active Update to " + activeUpdate);
        }
    }

    private Boolean getActiveUpdate(Boolean enableActiveUpdate, Boolean disableActiveUpdate) {
        if (enableActiveUpdate == null && disableActiveUpdate == null) {
            return null;
        }
        if (enableActiveUpdate != null && disableActiveUpdate != null) {
            throw new IllegalArgumentException("enable-active-update and disable-active-update cannot be used together");
        }
        return Boolean.TRUE.equals(enableActiveUpdate) ? Boolean.TRUE : Boolean.FALSE;
    }
}

