/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.schema.SchemaTransformation;

final class SchemaAnnouncementEvent
extends DiagnosticEvent {
    private final SchemaAnnouncementEventType type;
    @Nullable
    private final Set<InetAddressAndPort> schemaDestinationEndpoints;
    @Nullable
    private final Set<InetAddressAndPort> schemaEndpointsIgnored;
    @Nullable
    private final CQLStatement statement;
    @Nullable
    private final InetAddressAndPort sender;

    SchemaAnnouncementEvent(SchemaAnnouncementEventType type, @Nullable Set<InetAddressAndPort> schemaDestinationEndpoints, @Nullable Set<InetAddressAndPort> schemaEndpointsIgnored, @Nullable SchemaTransformation transformation, @Nullable InetAddressAndPort sender) {
        this.type = type;
        this.schemaDestinationEndpoints = schemaDestinationEndpoints;
        this.schemaEndpointsIgnored = schemaEndpointsIgnored;
        this.statement = transformation instanceof CQLStatement ? (CQLStatement)((Object)transformation) : null;
        this.sender = sender;
    }

    @Override
    public Enum<?> getType() {
        return this.type;
    }

    @Override
    public Map<String, Serializable> toMap() {
        AuditLogContext logContext;
        Set eps;
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (this.schemaDestinationEndpoints != null) {
            eps = this.schemaDestinationEndpoints.stream().map(Object::toString).collect(Collectors.toSet());
            ret.put("endpointDestinations", new HashSet(eps));
        }
        if (this.schemaEndpointsIgnored != null) {
            eps = this.schemaEndpointsIgnored.stream().map(Object::toString).collect(Collectors.toSet());
            ret.put("endpointIgnored", new HashSet(eps));
        }
        if (this.statement != null && (logContext = this.statement.getAuditLogContext()) != null) {
            HashMap<String, String> log = new HashMap<String, String>();
            if (logContext.auditLogEntryType != null) {
                log.put("type", logContext.auditLogEntryType.name());
            }
            if (logContext.keyspace != null) {
                log.put("keyspace", logContext.keyspace);
            }
            if (logContext.scope != null) {
                log.put("table", logContext.scope);
            }
            ret.put("statement", log);
        }
        if (this.sender != null) {
            ret.put("sender", (Serializable)((Object)this.sender.toString()));
        }
        return ret;
    }

    static enum SchemaAnnouncementEventType {
        SCHEMA_MUTATIONS_ANNOUNCED,
        SCHEMA_TRANSFORMATION_ANNOUNCED,
        SCHEMA_MUTATIONS_RECEIVED;

    }
}

