/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtableCleanerThread;

public abstract class MemtablePool {
    final MemtableCleanerThread<?> cleaner;
    public final SubPool onHeap;
    public final SubPool offHeap;
    final WaitQueue hasRoom = new WaitQueue();
    private static final AtomicLongFieldUpdater<SubPool> reclaimingUpdater = AtomicLongFieldUpdater.newUpdater(SubPool.class, "reclaiming");
    private static final AtomicLongFieldUpdater<SubPool> allocatedUpdater = AtomicLongFieldUpdater.newUpdater(SubPool.class, "allocated");
    private static final AtomicLongFieldUpdater<SubPool> nextCleanUpdater = AtomicLongFieldUpdater.newUpdater(SubPool.class, "nextClean");

    MemtablePool(long maxOnHeapMemory, long maxOffHeapMemory, float cleanThreshold, Runnable cleaner) {
        this.onHeap = this.getSubPool(maxOnHeapMemory, cleanThreshold);
        this.offHeap = this.getSubPool(maxOffHeapMemory, cleanThreshold);
        this.cleaner = this.getCleaner(cleaner);
        if (this.cleaner != null) {
            this.cleaner.start();
        }
    }

    SubPool getSubPool(long limit, float cleanThreshold) {
        return new SubPool(limit, cleanThreshold);
    }

    MemtableCleanerThread<?> getCleaner(Runnable cleaner) {
        return cleaner == null ? null : new MemtableCleanerThread<MemtablePool>(this, cleaner);
    }

    public abstract boolean needToCopyOnHeap();

    public abstract MemtableAllocator newAllocator();

    public class SubPool {
        public final long limit;
        public final float cleanThreshold;
        volatile long allocated;
        volatile long reclaiming;
        volatile long nextClean;

        public SubPool(long limit, float cleanThreshold) {
            this.limit = limit;
            this.cleanThreshold = cleanThreshold;
        }

        boolean needsCleaning() {
            return this.used() > this.nextClean && this.updateNextClean();
        }

        void maybeClean() {
            if (this.needsCleaning() && MemtablePool.this.cleaner != null) {
                MemtablePool.this.cleaner.trigger();
            }
        }

        private boolean updateNextClean() {
            long reclaiming;
            long next;
            long current;
            while ((current = this.nextClean) != (next = (reclaiming = this.reclaiming) + (long)((float)this.limit * this.cleanThreshold)) && !nextCleanUpdater.compareAndSet(this, current, next)) {
            }
            return this.used() > next;
        }

        boolean tryAllocate(long size) {
            long cur;
            do {
                if ((cur = this.allocated) + size <= this.limit) continue;
                return false;
            } while (!allocatedUpdater.compareAndSet(this, cur, cur + size));
            return true;
        }

        void adjustAllocated(long size) {
            long cur;
            if (size == 0L) {
                return;
            }
            do {
                cur = this.allocated;
            } while (!allocatedUpdater.compareAndSet(this, cur, cur + size));
        }

        void adjustAcquired(long size, boolean alsoAllocated) {
            if (size > 0L || alsoAllocated) {
                if (alsoAllocated) {
                    this.adjustAllocated(size);
                }
                this.maybeClean();
            } else if (size < 0L) {
                this.adjustAllocated(size);
                MemtablePool.this.hasRoom.signalAll();
            }
        }

        void adjustReclaiming(long reclaiming) {
            if (reclaiming == 0L) {
                return;
            }
            reclaimingUpdater.addAndGet(this, reclaiming);
            if (reclaiming < 0L && this.updateNextClean() && MemtablePool.this.cleaner != null) {
                MemtablePool.this.cleaner.trigger();
            }
        }

        public long allocated() {
            return this.allocated;
        }

        public long used() {
            return this.allocated;
        }

        public MemtableAllocator.SubAllocator newAllocator() {
            return new MemtableAllocator.SubAllocator(this);
        }

        public WaitQueue hasRoom() {
            return MemtablePool.this.hasRoom;
        }
    }
}

