/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRowResolver
implements IResponseResolver<ReadResponse, Row> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRowResolver.class);
    protected final String keyspaceName;
    protected final Queue<MessageIn<ReadResponse>> replies = new ConcurrentLinkedQueue<MessageIn<ReadResponse>>();
    protected final DecoratedKey key;

    public AbstractRowResolver(ByteBuffer key, String keyspaceName) {
        this.key = StorageService.getPartitioner().decorateKey(key);
        this.keyspaceName = keyspaceName;
    }

    @Override
    public void preprocess(MessageIn<ReadResponse> message) {
        this.replies.add(message);
    }

    @Override
    public Iterable<MessageIn<ReadResponse>> getMessages() {
        return this.replies;
    }
}

