/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.AbstractPartitioner;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractByteOrderedPartitioner
extends AbstractPartitioner {
    public static final BytesToken MINIMUM = new BytesToken(ArrayUtils.EMPTY_BYTE_ARRAY);
    public static final BigInteger BYTE_MASK = new BigInteger("255");
    private final Token.TokenFactory tokenFactory = new Token.TokenFactory(){

        @Override
        public ByteBuffer toByteArray(Token token) {
            BytesToken bytesToken = (BytesToken)token;
            return ByteBuffer.wrap(bytesToken.token);
        }

        @Override
        public Token fromByteArray(ByteBuffer bytes) {
            return new BytesToken(bytes);
        }

        @Override
        public String toString(Token token) {
            BytesToken bytesToken = (BytesToken)token;
            return Hex.bytesToHex(bytesToken.token);
        }

        @Override
        public void validate(String token) throws ConfigurationException {
            try {
                if (token.length() % 2 == 1) {
                    token = "0" + token;
                }
                Hex.hexToBytes(token);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Token " + token + " contains non-hex digits");
            }
        }

        @Override
        public Token fromString(String string) {
            if (string.length() % 2 == 1) {
                string = "0" + string;
            }
            return new BytesToken(Hex.hexToBytes(string));
        }
    };

    @Override
    public DecoratedKey decorateKey(ByteBuffer key) {
        return new BufferDecoratedKey(this.getToken(key), key);
    }

    @Override
    public BytesToken midpoint(Token lt, Token rt) {
        BytesToken ltoken = (BytesToken)lt;
        BytesToken rtoken = (BytesToken)rt;
        int sigbytes = Math.max(ltoken.token.length, rtoken.token.length);
        BigInteger left = this.bigForBytes(ltoken.token, sigbytes);
        BigInteger right = this.bigForBytes(rtoken.token, sigbytes);
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 8 * sigbytes);
        return new BytesToken(this.bytesForBig((BigInteger)midpair.left, sigbytes, (Boolean)midpair.right));
    }

    private BigInteger bigForBytes(byte[] bytes, int sigbytes) {
        byte[] b;
        if (sigbytes != bytes.length) {
            b = new byte[sigbytes];
            System.arraycopy(bytes, 0, b, 0, bytes.length);
        } else {
            b = bytes;
        }
        return new BigInteger(1, b);
    }

    private byte[] bytesForBig(BigInteger big, int sigbytes, boolean remainder) {
        byte[] bytes = new byte[sigbytes + (remainder ? 1 : 0)];
        if (remainder) {
            int n = sigbytes;
            bytes[n] = (byte)(bytes[n] | 0x80);
        }
        for (int i = 0; i < sigbytes; ++i) {
            int maskpos = 8 * (sigbytes - (i + 1));
            bytes[i] = (byte)(big.and(BYTE_MASK.shiftLeft(maskpos)).shiftRight(maskpos).intValue() & 0xFF);
        }
        return bytes;
    }

    @Override
    public BytesToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BytesToken getRandomToken() {
        Random r = new Random();
        byte[] buffer = new byte[16];
        r.nextBytes(buffer);
        return new BytesToken(buffer);
    }

    @Override
    public Token.TokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public abstract BytesToken getToken(ByteBuffer var1);

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap<Token, Float> allTokens = new HashMap<Token, Float>();
        ArrayList<Range<Token>> sortedRanges = new ArrayList<Range<Token>>(sortedTokens.size());
        Token lastToken = sortedTokens.get(sortedTokens.size() - 1);
        for (Token node : sortedTokens) {
            allTokens.put(node, new Float(0.0));
            sortedRanges.add(new Range<Token>(lastToken, node));
            lastToken = node;
        }
        for (String ks : Schema.instance.getKeyspaces()) {
            for (CFMetaData cfmd : Schema.instance.getKSMetaData(ks).cfMetaData().values()) {
                for (Range range : sortedRanges) {
                    allTokens.put((Token)range.right, Float.valueOf(((Float)allTokens.get(range.right)).floatValue() + (float)StorageService.instance.getSplits(ks, cfmd.cfName, range, 1).size()));
                }
            }
        }
        Float total = new Float(0.0);
        for (Float f : allTokens.values()) {
            total = Float.valueOf(total.floatValue() + f.floatValue());
        }
        for (Map.Entry entry : allTokens.entrySet()) {
            allTokens.put((Token)entry.getKey(), Float.valueOf(((Float)entry.getValue()).floatValue() / total.floatValue()));
        }
        return allTokens;
    }

    @Override
    public AbstractType<?> getTokenValidator() {
        return BytesType.instance;
    }
}

