/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.composites.AbstractSimpleCellNameType;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.composites.SimpleDenseCellName;
import org.apache.cassandra.db.marshal.AbstractType;

public class SimpleDenseCellNameType
extends AbstractSimpleCellNameType {
    public SimpleDenseCellNameType(AbstractType<?> type) {
        super(type);
    }

    @Override
    public int clusteringPrefixSize() {
        return 1;
    }

    @Override
    public CBuilder prefixBuilder() {
        return this.builder();
    }

    @Override
    public CellNameType setSubtype(int position, AbstractType<?> newType) {
        if (position != 0) {
            throw new IllegalArgumentException();
        }
        return new SimpleDenseCellNameType(newType);
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public CellName create(Composite prefix, ColumnDefinition column) {
        assert (prefix.size() == 1);
        return new SimpleDenseCellName(prefix.get(0));
    }

    @Override
    public Composite fromByteBuffer(ByteBuffer bb) {
        return !bb.hasRemaining() ? Composites.EMPTY : new SimpleDenseCellName(bb);
    }

    @Override
    public void addCQL3Column(ColumnIdentifier id) {
    }

    @Override
    public void removeCQL3Column(ColumnIdentifier id) {
    }

    @Override
    public CQL3Row.Builder CQL3RowBuilder(CFMetaData metadata, long now) {
        return SimpleDenseCellNameType.makeDenseCQL3RowBuilder(now);
    }
}

