/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public enum Operator {
    EQ(0),
    LT(4),
    LTE(3),
    GTE(1),
    GT(2),
    IN(7),
    CONTAINS(5),
    CONTAINS_KEY(6),
    NEQ(8);

    private final int b;

    private Operator(int b) {
        this.b = b;
    }

    public void writeTo(DataOutput output) throws IOException {
        output.writeInt(this.b);
    }

    public static Operator readFrom(DataInput input) throws IOException {
        int b = input.readInt();
        for (Operator operator : Operator.values()) {
            if (operator.b != b) continue;
            return operator;
        }
        throw new IOException(String.format("Cannot resolve Relation.Type from binary representation: %s", b));
    }

    public String toString() {
        switch (this) {
            case EQ: {
                return "=";
            }
            case LT: {
                return "<";
            }
            case LTE: {
                return "<=";
            }
            case GT: {
                return ">";
            }
            case GTE: {
                return ">=";
            }
            case NEQ: {
                return "!=";
            }
            case CONTAINS_KEY: {
                return "CONTAINS KEY";
            }
        }
        return this.name();
    }
}

