/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;

public class MultiColumnRelation
extends Relation {
    private final List<ColumnIdentifier.Raw> entities;
    private final Term.MultiColumnRaw valuesOrMarker;
    private final List<? extends Term.MultiColumnRaw> inValues;
    private final Tuples.INRaw inMarker;

    private MultiColumnRelation(List<ColumnIdentifier.Raw> entities, Operator relationType, Term.MultiColumnRaw valuesOrMarker, List<? extends Term.MultiColumnRaw> inValues, Tuples.INRaw inMarker) {
        this.entities = entities;
        this.relationType = relationType;
        this.valuesOrMarker = valuesOrMarker;
        this.inValues = inValues;
        this.inMarker = inMarker;
    }

    public static MultiColumnRelation createNonInRelation(List<ColumnIdentifier.Raw> entities, Operator relationType, Term.MultiColumnRaw valuesOrMarker) {
        assert (relationType != Operator.IN);
        return new MultiColumnRelation(entities, relationType, valuesOrMarker, null, null);
    }

    public static MultiColumnRelation createInRelation(List<ColumnIdentifier.Raw> entities, List<? extends Term.MultiColumnRaw> inValues) {
        return new MultiColumnRelation(entities, Operator.IN, null, inValues, null);
    }

    public static MultiColumnRelation createSingleMarkerInRelation(List<ColumnIdentifier.Raw> entities, Tuples.INRaw inMarker) {
        return new MultiColumnRelation(entities, Operator.IN, null, null, inMarker);
    }

    public List<ColumnIdentifier.Raw> getEntities() {
        return this.entities;
    }

    public Term.MultiColumnRaw getValue() {
        assert (this.relationType != Operator.IN);
        return this.valuesOrMarker;
    }

    public List<? extends Term.MultiColumnRaw> getInValues() {
        return this.inValues;
    }

    public Tuples.INRaw getInMarker() {
        return this.inMarker;
    }

    @Override
    public boolean isMultiColumn() {
        return true;
    }

    public String toString() {
        if (this.relationType == Operator.IN) {
            StringBuilder sb = new StringBuilder(Tuples.tupleToString(this.entities));
            sb.append(" IN ");
            sb.append(this.inMarker != null ? Character.valueOf('?') : Tuples.tupleToString(this.inValues));
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(Tuples.tupleToString(this.entities));
        sb.append(" ");
        sb.append((Object)this.relationType);
        sb.append(" ");
        sb.append(this.valuesOrMarker);
        return sb.toString();
    }
}

