/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.util.RatioGauge;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.cache.ICache;

public class CacheMetrics {
    public static final String GROUP_NAME = "org.apache.cassandra.metrics";
    public static final String TYPE_NAME = "Cache";
    public final Gauge<Long> capacity;
    public final Meter hits;
    public final Meter requests;
    public final Gauge<Double> hitRate;
    public final Gauge<Long> size;
    public final Gauge<Integer> entries;
    private final AtomicLong lastRequests = new AtomicLong(0L);
    private final AtomicLong lastHits = new AtomicLong(0L);

    public CacheMetrics(String type, final ICache cache) {
        this.capacity = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "Capacity", type), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.capacity();
            }
        });
        this.hits = Metrics.newMeter((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "Hits", type), (String)"hits", (TimeUnit)TimeUnit.SECONDS);
        this.requests = Metrics.newMeter((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "Requests", type), (String)"requests", (TimeUnit)TimeUnit.SECONDS);
        this.hitRate = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "HitRate", type), (Gauge)new RatioGauge(){

            protected double getNumerator() {
                return CacheMetrics.this.hits.count();
            }

            protected double getDenominator() {
                return CacheMetrics.this.requests.count();
            }
        });
        this.size = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "Size", type), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.weightedSize();
            }
        });
        this.entries = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "Entries", type), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return cache.size();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public double getRecentHitRate() {
        long r = this.requests.count();
        long h = this.hits.count();
        try {
            double d = (double)(h - this.lastHits.get()) / (double)(r - this.lastRequests.get());
            return d;
        }
        finally {
            this.lastRequests.set(r);
            this.lastHits.set(h);
        }
    }
}

