/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class BulkLoader {
    private static final String TOOL_NAME = "sstableloader";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String DEBUG_OPTION = "debug";
    private static final String HELP_OPTION = "help";
    private static final String NOPROGRESS_OPTION = "no-progress";
    private static final String IGNORE_NODES_OPTION = "ignore";
    private static final String INITIAL_HOST_ADDRESS_OPTION = "nodes";
    private static final String RPC_PORT_OPTION = "port";
    private static final String THROTTLE_MBITS = "throttle";

    public static void main(String[] args) throws IOException {
        LoaderOptions options = LoaderOptions.parseArgs(args);
        try {
            SSTableLoader loader = new SSTableLoader(options.directory, new ExternalClient(options, options.hosts, options.rpcPort), options);
            DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(options.throttle);
            SSTableLoader.LoaderFuture future = loader.stream(options.ignores);
            if (options.noProgress) {
                future.get();
            } else {
                ProgressIndicator indicator = new ProgressIndicator(future.getPendingFiles());
                indicator.start();
                System.out.println("");
                boolean printEnd = false;
                while (!future.isDone()) {
                    if (indicator.printProgress()) {
                        System.out.println("\nWaiting for targets to rebuild indexes ...");
                        printEnd = true;
                        future.get();
                        assert (future.isDone());
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {}
                }
                if (!printEnd) {
                    indicator.printProgress();
                }
                if (future.hadFailures()) {
                    System.err.println("Streaming to the following hosts failed:");
                    System.err.println(future.getFailedHosts());
                    System.exit(1);
                }
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (options.debug) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private static class CmdLineOptions
    extends Options {
        private CmdLineOptions() {
        }

        public Options addOption(String opt, String longOpt, String argName, String description) {
            Option option = new Option(opt, longOpt, true, description);
            option.setArgName(argName);
            return this.addOption(option);
        }

        public Options addOption(String opt, String longOpt, String description) {
            return this.addOption(new Option(opt, longOpt, false, description));
        }
    }

    static class LoaderOptions
    implements SSTableLoader.OutputHandler {
        public final File directory;
        public boolean debug;
        public boolean verbose;
        public boolean noProgress;
        public int rpcPort = 9160;
        public int throttle = 0;
        public Set<InetAddress> hosts = new HashSet<InetAddress>();
        public Set<InetAddress> ignores = new HashSet<InetAddress>();

        LoaderOptions(File directory) {
            this.directory = directory;
        }

        public static LoaderOptions parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            CmdLineOptions options = LoaderOptions.getCmdLineOptions();
            try {
                String[] nodes;
                String dirname;
                File dir;
                String[] args;
                CommandLine cmd = parser.parse((Options)options, cmdArgs, false);
                if (cmd.hasOption(BulkLoader.HELP_OPTION)) {
                    LoaderOptions.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length == 0) {
                    System.err.println("Missing sstable directory argument");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (args.length > 1) {
                    System.err.println("Too many arguments");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (!(dir = new File(dirname = args[0])).exists()) {
                    LoaderOptions.errorMsg("Unknown directory: " + dirname, options);
                }
                if (!dir.isDirectory()) {
                    LoaderOptions.errorMsg(dirname + " is not a directory", options);
                }
                LoaderOptions opts = new LoaderOptions(dir);
                opts.debug = cmd.hasOption(BulkLoader.DEBUG_OPTION);
                opts.verbose = cmd.hasOption(BulkLoader.VERBOSE_OPTION);
                opts.noProgress = cmd.hasOption(BulkLoader.NOPROGRESS_OPTION);
                if (cmd.hasOption(BulkLoader.THROTTLE_MBITS)) {
                    opts.throttle = Integer.valueOf(cmd.getOptionValue(BulkLoader.THROTTLE_MBITS));
                }
                if (cmd.hasOption(BulkLoader.RPC_PORT_OPTION)) {
                    opts.rpcPort = Integer.valueOf(cmd.getOptionValue(BulkLoader.RPC_PORT_OPTION));
                }
                if (cmd.hasOption(BulkLoader.INITIAL_HOST_ADDRESS_OPTION)) {
                    nodes = cmd.getOptionValue(BulkLoader.INITIAL_HOST_ADDRESS_OPTION).split(",");
                    try {
                        for (String node : nodes) {
                            opts.hosts.add(InetAddress.getByName(node.trim()));
                        }
                    }
                    catch (UnknownHostException e) {
                        LoaderOptions.errorMsg("Unknown host: " + e.getMessage(), options);
                    }
                } else {
                    System.err.println("Initial hosts must be specified (-d)");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (cmd.hasOption(BulkLoader.IGNORE_NODES_OPTION)) {
                    nodes = cmd.getOptionValue(BulkLoader.IGNORE_NODES_OPTION).split(",");
                    try {
                        for (String node : nodes) {
                            opts.ignores.add(InetAddress.getByName(node.trim()));
                        }
                    }
                    catch (UnknownHostException e) {
                        LoaderOptions.errorMsg("Unknown host: " + e.getMessage(), options);
                    }
                }
                return opts;
            }
            catch (ParseException e) {
                LoaderOptions.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        private static void errorMsg(String msg, CmdLineOptions options) {
            System.err.println(msg);
            LoaderOptions.printUsage(options);
            System.exit(1);
        }

        @Override
        public void output(String msg) {
            System.out.println(msg);
        }

        @Override
        public void debug(String msg) {
            if (this.verbose) {
                System.out.println(msg);
            }
        }

        private static CmdLineOptions getCmdLineOptions() {
            CmdLineOptions options = new CmdLineOptions();
            options.addOption(null, BulkLoader.DEBUG_OPTION, "display stack traces");
            options.addOption("v", BulkLoader.VERBOSE_OPTION, "verbose output");
            options.addOption("h", BulkLoader.HELP_OPTION, "display this help message");
            options.addOption(null, BulkLoader.NOPROGRESS_OPTION, "don't display progress");
            options.addOption("i", BulkLoader.IGNORE_NODES_OPTION, "NODES", "don't stream to this (comma separated) list of nodes");
            options.addOption("d", BulkLoader.INITIAL_HOST_ADDRESS_OPTION, "initial hosts", "try to connect to these hosts (comma separated) initially for ring information");
            options.addOption("p", BulkLoader.RPC_PORT_OPTION, "rpc port", "port used for rpc (default 9160)");
            options.addOption("t", BulkLoader.THROTTLE_MBITS, BulkLoader.THROTTLE_MBITS, "throttle speed in Mbits (default unlimited)");
            return options;
        }

        public static void printUsage(Options options) {
            String usage = String.format("%s [options] <dir_path>", BulkLoader.TOOL_NAME);
            StringBuilder header = new StringBuilder();
            header.append("--\n");
            header.append("Bulk load the sstables found in the directory <dir_path> to the configured cluster.");
            header.append("The parent directory of <dir_path> is used as the keyspace name. ");
            header.append("So for instance, to load an sstable named Standard1-g-1-Data.db into keyspace Keyspace1, ");
            header.append("you will need to have the files Standard1-g-1-Data.db and Standard1-g-1-Index.db in a ");
            header.append("directory Keyspace1/Standard1/ in the directory and call: sstableloader Keyspace1/Standard1");
            header.append("\n--\n");
            header.append("Options are:");
            new HelpFormatter().printHelp(usage, header.toString(), options, "");
        }
    }

    static class ExternalClient
    extends SSTableLoader.Client {
        private final Map<String, Set<String>> knownCfs = new HashMap<String, Set<String>>();
        private final SSTableLoader.OutputHandler outputHandler;
        private Set<InetAddress> hosts = new HashSet<InetAddress>();
        private int rpcPort;

        public ExternalClient(SSTableLoader.OutputHandler outputHandler, Set<InetAddress> hosts, int port) {
            this.outputHandler = outputHandler;
            this.hosts = hosts;
            this.rpcPort = port;
        }

        @Override
        public void init(String keyspace) {
            Iterator<InetAddress> hostiter = this.hosts.iterator();
            while (hostiter.hasNext()) {
                try {
                    InetAddress host = hostiter.next();
                    Cassandra.Client client = ExternalClient.createThriftClient(host.getHostAddress(), this.rpcPort);
                    List tokenRanges = client.describe_ring(keyspace);
                    List ksDefs = client.describe_keyspaces();
                    this.setPartitioner(client.describe_partitioner());
                    Token.TokenFactory tkFactory = this.getPartitioner().getTokenFactory();
                    for (TokenRange tr : tokenRanges) {
                        Range<Token> range = new Range<Token>(tkFactory.fromString(tr.start_token), tkFactory.fromString(tr.end_token));
                        for (String ep : tr.endpoints) {
                            this.addRangeForEndpoint(range, InetAddress.getByName(ep));
                        }
                    }
                    for (KsDef ksDef : ksDefs) {
                        HashSet<String> cfs = new HashSet<String>();
                        for (CfDef cfDef : ksDef.cf_defs) {
                            cfs.add(cfDef.name);
                        }
                        this.knownCfs.put(ksDef.name, cfs);
                    }
                    break;
                }
                catch (Exception e) {
                    if (hostiter.hasNext()) continue;
                    throw new RuntimeException("Could not retrieve endpoint ranges: ", e);
                }
            }
        }

        @Override
        public boolean validateColumnFamily(String keyspace, String cfName) {
            Set<String> cfs = this.knownCfs.get(keyspace);
            return cfs != null && cfs.contains(cfName);
        }

        private static Cassandra.Client createThriftClient(String host, int port) throws TTransportException {
            TSocket socket = new TSocket(host, port);
            TFramedTransport trans = new TFramedTransport((TTransport)socket);
            trans.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)trans);
            return new Cassandra.Client((TProtocol)protocol);
        }
    }

    static class ProgressIndicator {
        private final Map<InetAddress, Collection<PendingFile>> filesByHost;
        private long startTime;
        private long lastProgress;
        private long lastTime;

        public ProgressIndicator(Map<InetAddress, Collection<PendingFile>> filesByHost) {
            this.filesByHost = new HashMap<InetAddress, Collection<PendingFile>>(filesByHost);
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public boolean printProgress() {
            boolean done = true;
            StringBuilder sb = new StringBuilder();
            sb.append("\rprogress: ");
            long totalProgress = 0L;
            long totalSize = 0L;
            for (Map.Entry<InetAddress, Collection<PendingFile>> entry : this.filesByHost.entrySet()) {
                long progress = 0L;
                long size = 0L;
                int completed = 0;
                Collection<PendingFile> pendings = entry.getValue();
                for (PendingFile f : pendings) {
                    progress += f.progress;
                    size += f.size;
                    if (f.progress != f.size) continue;
                    ++completed;
                }
                totalProgress += progress;
                totalSize += size;
                if (completed != pendings.size()) {
                    done = false;
                }
                sb.append("[").append(entry.getKey());
                sb.append(" ").append(completed).append("/").append(pendings.size());
                sb.append(" (").append(size == 0L ? 100L : progress * 100L / size).append(")] ");
            }
            long time = System.currentTimeMillis();
            long deltaTime = time - this.lastTime;
            this.lastTime = time;
            long deltaProgress = totalProgress - this.lastProgress;
            this.lastProgress = totalProgress;
            sb.append("[total: ").append(totalSize == 0L ? 100L : totalProgress * 100L / totalSize).append(" - ");
            sb.append(this.mbPerSec(deltaProgress, deltaTime)).append("MB/s");
            sb.append(" (avg: ").append(this.mbPerSec(totalProgress, time - this.startTime)).append("MB/s)]");
            System.out.print(sb.toString());
            return done;
        }

        private int mbPerSec(long bytes, long timeInMs) {
            double bytesPerMs = (double)bytes / (double)timeInMs;
            return (int)(bytesPerMs * 1000.0 / 2072576.0);
        }
    }
}

