/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class Message {
    final Header header_;
    private final byte[] body_;
    private final transient int version;

    public Message(Header header, byte[] body, int version) {
        assert (header != null);
        assert (body != null);
        this.header_ = header;
        this.body_ = body;
        this.version = version;
    }

    public Message(InetAddress from, StorageService.Verb verb, byte[] body, int version) {
        this(new Header(from, verb), body, version);
    }

    public byte[] getHeader(String key) {
        return this.header_.getDetail(key);
    }

    public Message withHeaderAdded(String key, byte[] value) {
        return new Message(this.header_.withDetailsAdded(key, value), this.body_, this.version);
    }

    public Message withHeaderRemoved(String key) {
        return new Message(this.header_.withDetailsRemoved(key), this.body_, this.version);
    }

    public byte[] getMessageBody() {
        return this.body_;
    }

    public int getVersion() {
        return this.version;
    }

    public InetAddress getFrom() {
        return this.header_.getFrom();
    }

    public Stage getMessageType() {
        return StorageService.verbStages.get((Object)this.getVerb());
    }

    public StorageService.Verb getVerb() {
        return this.header_.getVerb();
    }

    public Message getReply(InetAddress from, byte[] body, int version) {
        Header header = new Header(from, StorageService.Verb.REQUEST_RESPONSE);
        return new Message(header, body, version);
    }

    public Message getInternalReply(byte[] body, int version) {
        Header header = new Header(FBUtilities.getBroadcastAddress(), StorageService.Verb.INTERNAL_RESPONSE);
        return new Message(header, body, version);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("");
        String separator = System.getProperty("line.separator");
        sbuf.append("FROM:" + this.getFrom()).append(separator).append("TYPE:" + (Object)((Object)this.getMessageType())).append(separator).append("VERB:" + (Object)((Object)this.getVerb())).append(separator);
        return sbuf.toString();
    }
}

