/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;

public class SimpleStrategy
extends AbstractReplicationStrategy {
    public SimpleStrategy(String table, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        super(table, tokenMetadata, snitch, configOptions);
    }

    @Override
    public List<InetAddress> calculateNaturalEndpoints(Token token, TokenMetadata metadata) {
        int replicas = this.getReplicationFactor();
        ArrayList<Token> tokens = metadata.sortedTokens();
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(replicas);
        if (tokens.isEmpty()) {
            return endpoints;
        }
        Iterator<Token> iter = TokenMetadata.ringIterator(tokens, token, false);
        while (endpoints.size() < replicas && iter.hasNext()) {
            endpoints.add(metadata.getEndpoint(iter.next()));
        }
        return endpoints;
    }

    @Override
    public int getReplicationFactor() {
        return Integer.parseInt((String)this.configOptions.get("replication_factor"));
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        if (this.configOptions == null || this.configOptions.get("replication_factor") == null) {
            throw new ConfigurationException("SimpleStrategy requires a replication_factor strategy option.");
        }
        this.warnOnUnexpectedOptions(Arrays.asList("replication_factor"));
        this.validateReplicationFactor((String)this.configOptions.get("replication_factor"));
    }
}

