/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.compaction.OperationType;

public final class CompactionInfo
implements Serializable {
    private static final long serialVersionUID = 3695381572726744816L;
    private final CFMetaData cfm;
    private final OperationType tasktype;
    private final long bytesComplete;
    private final long totalBytes;

    public CompactionInfo(OperationType tasktype, long bytesComplete, long totalBytes) {
        this(null, tasktype, bytesComplete, totalBytes);
    }

    public CompactionInfo(Integer id, OperationType tasktype, long bytesComplete, long totalBytes) {
        this.tasktype = tasktype;
        this.bytesComplete = bytesComplete;
        this.totalBytes = totalBytes;
        this.cfm = id == null ? null : Schema.instance.getCFMetaData(id);
    }

    public CompactionInfo forProgress(long bytesComplete, long totalBytes) {
        return new CompactionInfo(this.cfm == null ? null : this.cfm.cfId, this.tasktype, bytesComplete, totalBytes);
    }

    public Integer getId() {
        return this.cfm == null ? null : this.cfm.cfId;
    }

    public String getKeyspace() {
        return this.cfm == null ? null : this.cfm.ksName;
    }

    public String getColumnFamily() {
        return this.cfm == null ? null : this.cfm.cfName;
    }

    public CFMetaData getCFMetaData() {
        return this.cfm;
    }

    public long getBytesComplete() {
        return this.bytesComplete;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public OperationType getTaskType() {
        return this.tasktype;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append((Object)this.getTaskType()).append('@').append(this.getId());
        buff.append('(').append(this.getKeyspace()).append(", ").append(this.getColumnFamily());
        buff.append(", ").append(this.getBytesComplete()).append('/').append(this.getTotalBytes());
        return buff.append(')').toString();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("id", Integer.toString(this.getId()));
        ret.put("keyspace", this.getKeyspace());
        ret.put("columnfamily", this.getColumnFamily());
        ret.put("bytesComplete", Long.toString(this.bytesComplete));
        ret.put("totalBytes", Long.toString(this.totalBytes));
        ret.put("taskType", this.tasktype.toString());
        return ret;
    }

    public static abstract class Holder {
        private volatile boolean stopRequested = false;

        public abstract CompactionInfo getCompactionInfo();

        public void stop() {
            this.stopRequested = true;
        }

        public boolean isStopRequested() {
            return this.stopRequested;
        }
    }
}

