/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.io.sstable.SSTableReader;

public abstract class AbstractCompactionTask {
    protected ColumnFamilyStore cfs;
    protected Collection<SSTableReader> sstables;

    public AbstractCompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables) {
        this.cfs = cfs;
        this.sstables = sstables;
    }

    public abstract int execute(CompactionManager.CompactionExecutorStatsCollector var1) throws IOException;

    public ColumnFamilyStore getColumnFamilyStore() {
        return this.cfs;
    }

    public Collection<SSTableReader> getSSTables() {
        return this.sstables;
    }

    public boolean markSSTablesForCompaction() {
        return this.markSSTablesForCompaction(this.cfs.getMinimumCompactionThreshold(), this.cfs.getMaximumCompactionThreshold());
    }

    public boolean markSSTablesForCompaction(int min, int max) {
        Set<SSTableReader> marked = this.cfs.getDataTracker().markCompacting(this.sstables, min, max);
        if (marked == null || marked.isEmpty()) {
            this.cancel();
            return false;
        }
        this.sstables = marked;
        return true;
    }

    public void unmarkSSTables() {
        this.cfs.getDataTracker().unmarkCompacting(this.sstables);
    }

    protected void cancel() {
    }

    public String toString() {
        return "CompactionTask(" + this.sstables + ")";
    }
}

