/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.thrift.InvalidRequestException;

public abstract class CFStatement
extends ParsedStatement {
    protected final CFName cfName;

    protected CFStatement(CFName cfName) {
        this.cfName = cfName;
    }

    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.cfName.hasKeyspace()) {
            this.cfName.setKeyspace(state.getKeyspace(), true);
        }
    }

    public String keyspace() {
        assert (this.cfName.hasKeyspace()) : "The statement hasn't be prepared correctly";
        return this.cfName.getKeyspace();
    }

    public String columnFamily() {
        return this.cfName.getColumnFamily();
    }
}

