/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.JdbcBytes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public class BytesType
extends AbstractType<ByteBuffer> {
    public static final BytesType instance = new BytesType();

    BytesType() {
    }

    @Override
    public ByteBuffer compose(ByteBuffer bytes) {
        return JdbcBytes.instance.compose(bytes);
    }

    @Override
    public ByteBuffer decompose(ByteBuffer value) {
        return value;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return BytesType.bytesCompare(o1, o2);
    }

    public static int bytesCompare(ByteBuffer o1, ByteBuffer o2) {
        if (null == o1) {
            if (null == o2) {
                return 0;
            }
            return -1;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return JdbcBytes.instance.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        try {
            return ByteBuffer.wrap(FBUtilities.hexToBytes(source));
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
    }
}

