/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperationClient;
import org.apache.axis2.i18n.Messages;

public class OutOnlyAxisOperation
extends AxisOperation {
    private AxisMessage inFaultMessage;
    private ArrayList inPhases;
    private AxisMessage outFaultMessage;
    private AxisMessage outMessage;

    public OutOnlyAxisOperation() {
        QName tmpName = new QName(this.getClass().getName() + "_" + UUIDGenerator.getUUID());
        this.setName(tmpName);
        this.createMessage();
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/out-only");
    }

    public OutOnlyAxisOperation(QName name) {
        super(name);
        this.createMessage();
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/out-only");
    }

    public void addMessage(AxisMessage message, String label) {
        if (!"Out".equals(label)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.outMessage = message;
    }

    public void addMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        if (opContext.isComplete()) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        opContext.getMessageContexts().put("Out", msgContext);
        opContext.setComplete(true);
    }

    public void addFaultMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        HashMap mep = opContext.getMessageContexts();
        MessageContext faultMessageCtxt = (MessageContext)mep.get("Fault");
        if (faultMessageCtxt != null) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        mep.put("Fault", msgContext);
        opContext.setComplete(true);
        opContext.cleanup();
    }

    private void createMessage() {
        this.outMessage = new AxisMessage();
        this.outMessage.setDirection("out");
        this.outMessage.setParent(this);
        this.inFaultMessage = new AxisMessage();
        this.inFaultMessage.setParent(this);
        this.outFaultMessage = new AxisMessage();
        this.outFaultMessage.setParent(this);
        this.inPhases = new ArrayList();
    }

    public AxisMessage getMessage(String label) {
        if ("Out".equals(label)) {
            return this.outMessage;
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ArrayList getPhasesInFaultFlow() {
        return this.inFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFaultFlow() {
        return this.outFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFlow() {
        return this.outMessage.getMessageFlow();
    }

    public ArrayList getRemainingPhasesInFlow() {
        return this.inPhases;
    }

    public void setPhasesInFaultFlow(ArrayList list) {
        this.inFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFaultFlow(ArrayList list) {
        this.outFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFlow(ArrayList list) {
        this.outMessage.setMessageFlow(list);
    }

    public void setRemainingPhasesInFlow(ArrayList list) {
        this.inPhases = list;
    }

    public OperationClient createClient(ServiceContext sc, Options options) {
        return new OutOnlyAxisOperationClient(this, sc, options);
    }
}

