/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.axis2.wsdl.util;

public interface Constants {

    String BASE_64_PROPERTY_KEY = "base64map";
    String PLAIN_BASE_64_PROPERTY_KEY = "plainbase64map";

    String EXTERNAL_TEMPLATE_PROPERTY_KEY = "externalTemplate";
    String XSLT_INCLUDE_DATABIND_SUPPORTER_HREF_KEY = "databindsupporter";
    String XSLT_INCLUDE_TEST_OBJECT_HREF_KEY = "testObject";
    String UNWRAPPED_KEY = "UnWrapped";
    String UNWRAPPED_DETAILS = "UnWrapped_details";

    String COMPLEX_TYPE = "complexType";
    String ARRAY_TYPE = "arrayType";

    public static final String ANY_ELEMENT_FIELD_NAME = "extraElement";

    /**
     * Property for message receiver operation method handled by databinding code generation. This
     * is an optional parameter for an {@link org.apache.axis2.description.AxisOperation}. If
     * present, the value is the name of a method to be generated by the databinding code generation
     * and called by the message receiver code generation in order to process the OMElement and
     * invoke the service method.
     */
    String DATABINDING_GENERATED_RECEIVER = "databinding-generated-receiver";

    /**
     * Property for interface implementation method handled by databinding code generation. This is
     * an optional parameter for an {@link org.apache.axis2.description.AxisOperation}. If present,
     * the value is a <code>Boolean</code> flag to indicate that the method corresponding to that
     * operation will be generated by the data binding code generation.
     */
    String DATABINDING_GENERATED_IMPLEMENTATION = "databinding-generated-implementation";

    /**
     * Property for details to be passed inside the &lt;databinders> element. This is an optional
     * parameter for an {@link org.apache.axis2.description.AxisOperation}. If present, the value is
     * a DOM element to be appended to the &lt;databinders> content.
     */
    String DATABINDING_OPERATION_DETAILS = "databinding-operation-details";

    /**
     * Property for details to be passed inside the &lt;databinders> element. This is an optional
     * parameter for an {@link org.apache.axis2.description.AxisService}. If present, the value is a
     * DOM element to be appended to the &lt;databinders> content.
     */
    String DATABINDING_SERVICE_DETAILS = "databinding-service-details";


    public interface CodegenStyle {
        final int AUTOMATIC = 0;
        final int INTERFACE = 1;
        static final int BINDING = 2;
    }


}
