/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.util.CommandMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAgent
implements Service,
ExceptionListener {
    private static final Logger LOG = LoggerFactory.getLogger(CommandAgent.class);
    private String brokerUrl = "vm://localhost";
    private String username;
    private String password;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Destination commandDestination;
    private CommandMessageListener listener;
    private Session session;
    private MessageConsumer consumer;

    @PostConstruct
    public void start() throws Exception {
        this.session = this.getConnection().createSession(false, 1);
        this.listener = new CommandMessageListener(this.session);
        Destination destination = this.getCommandDestination();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Agent subscribing to control destination: " + destination);
        }
        this.consumer = this.session.createConsumer(destination);
        this.consumer.setMessageListener((MessageListener)this.listener);
    }

    @PreDestroy
    public void stop() throws Exception {
        if (this.consumer != null) {
            try {
                this.consumer.close();
                this.consumer = null;
            }
            catch (JMSException ignored) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
                this.session = null;
            }
            catch (JMSException ignored) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new ActiveMQConnectionFactory(this.brokerUrl);
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection getConnection() throws JMSException {
        if (this.connection == null) {
            this.connection = this.createConnection();
            this.connection.setExceptionListener((ExceptionListener)this);
            this.connection.start();
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Destination getCommandDestination() {
        if (this.commandDestination == null) {
            this.commandDestination = this.createCommandDestination();
        }
        return this.commandDestination;
    }

    public void setCommandDestination(Destination commandDestination) {
        this.commandDestination = commandDestination;
    }

    protected Connection createConnection() throws JMSException {
        return this.getConnectionFactory().createConnection(this.username, this.password);
    }

    protected Destination createCommandDestination() {
        return AdvisorySupport.getAgentDestination();
    }

    public void onException(JMSException exception) {
        try {
            this.stop();
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }
}

