/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml;

import org.andromda.core.mapping.Mapping;
import org.andromda.core.mapping.Mappings;
import org.apache.commons.lang.StringUtils;

public final class TypeMappings {
    private Mappings mappings = null;
    private String arraySuffix = null;

    private TypeMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public void setArraySuffix(String arraySuffix) {
        this.arraySuffix = arraySuffix;
    }

    public static TypeMappings getInstance(Mappings mappings) {
        return new TypeMappings(mappings);
    }

    public static TypeMappings getInstance(String mappingsUri) {
        return TypeMappings.getInstance(Mappings.getInstance((String)mappingsUri));
    }

    public String getTo(String from) {
        String initialFrom = from = StringUtils.trimToEmpty((String)from);
        String to = null;
        Mapping mapping = this.mappings.getMapping(from);
        if (mapping == null && this.arraySuffix != null) {
            boolean isArray = from.endsWith(this.arraySuffix);
            if (isArray) {
                from = StringUtils.replace((String)from, (String)this.arraySuffix, (String)"");
            }
            if ((mapping = this.mappings.getMapping(from)) != null) {
                StringBuilder toBuffer = new StringBuilder(mapping.getTo());
                if (isArray) {
                    toBuffer.append(this.arraySuffix);
                }
                to = toBuffer.toString();
            }
        } else if (mapping != null) {
            to = mapping.getTo();
        }
        if (to == null) {
            to = initialFrom;
        }
        return StringUtils.trimToEmpty((String)to);
    }

    public Mappings getMappings() {
        return this.mappings;
    }
}

