/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class RenameFileTest
extends Test {
    private static final String TestFileName = "renameFile";
    private static final String TestFileExt = ".txt";
    private static final String TestFileNewExt = ".renamed";

    public RenameFileTest() {
        super("RenameFile");
    }

    @Override
    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFileName = "renameFile_" + threadId + "_" + iteration + TestFileExt;
            String newFileName = "renameFile_" + threadId + "_" + iteration + TestFileNewExt;
            this.testLog(log, "RenameFile Test");
            if (sess.FileExists(testFileName)) {
                this.testLog(log, "File " + testFileName + " exists");
                result = new BooleanTestResult(false, "File already exists, " + testFileName);
            } else {
                this.testLog(log, "Creating file " + testFileName + " via " + sess.getServer());
                SMBFile testFile = sess.CreateFile(testFileName);
                if (testFile != null) {
                    testFile.Close();
                }
                if (sess.FileExists(testFileName)) {
                    sess.RenameFile(testFileName, newFileName);
                    result = sess.FileExists(newFileName) ? (!sess.FileExists(testFileName) ? new BooleanTestResult(true) : new BooleanTestResult(false, "Old file exists after rename, " + testFileName)) : new BooleanTestResult(false, "New file does not exist after rename, " + newFileName);
                } else {
                    this.testLog(log, "** File does not exist after create");
                    result = new BooleanTestResult(false, "File does not exist, " + testFileName);
                }
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    @Override
    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        String fName = "renameFile_" + threadId + "_" + iter + TestFileNewExt;
        sess.DeleteFile(fName);
    }
}

