/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.nt;

public class RID {
    public static final int TypeUser = 1;
    public static final int TypeDomainGroup = 2;
    public static final int TypeDomain = 3;
    public static final int TypeAlias = 4;
    public static final int TypeWellKnownGroup = 5;
    public static final int TypeDeleted = 6;
    public static final int TypeInvalid = 7;
    public static final int TypeUnknown = 8;
    private static final String[] _types = new String[]{"User", "DomainGroup", "Domain", "Alias", "WellKnownGroup", "Deleted", "Invalid", "Unknown"};
    private int m_rid;
    private int m_type;
    private String m_name;

    public RID() {
    }

    public RID(int rid, int type, String name) {
        this.m_rid = rid;
        this.m_type = type;
        this.m_name = name;
    }

    public final int getRID() {
        return this.m_rid;
    }

    public final int isType() {
        return this.m_type;
    }

    public final String getTypeString() {
        return RID.getTypeAsString(this.isType());
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setRID(int id) {
        this.m_rid = id;
    }

    public final void setType(int typ) {
        this.m_type = typ;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public static final String getTypeAsString(int typ) {
        if (typ >= 1 && typ <= 8) {
            return _types[typ - 1];
        }
        return null;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getRID());
        str.append(":");
        str.append(this.getTypeString());
        str.append(":");
        str.append(this.getName());
        str.append("]");
        return str.toString();
    }
}

