/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.loader;

import java.io.File;
import java.io.IOException;
import org.alfresco.jlan.debug.Debug;

public class FileSegmentInfo {
    public static final int Initial = 0;
    public static final int LoadWait = 1;
    public static final int Loading = 2;
    public static final int Available = 3;
    public static final int SaveWait = 4;
    public static final int Saving = 5;
    public static final int Saved = 6;
    public static final int Error = 7;
    private static final int Updated = 1;
    private static final int RequestQueued = 2;
    private static final int DeleteOnStore = 4;
    private static final String[] _statusStr = new String[]{"Initial", "LoadWait", "Loading", "Available", "SaveWait", "Saving", "Saved", "Error"};
    private String m_tempFile;
    private int m_flags;
    private int m_status = 0;
    private long m_readable;

    public FileSegmentInfo() {
    }

    public FileSegmentInfo(String tempFile) {
        this.setTemporaryFile(tempFile);
    }

    public final String getTemporaryFile() {
        return this.m_tempFile;
    }

    public final boolean isUpdated() {
        return (this.m_flags & 1) != 0;
    }

    public final boolean isQueued() {
        return (this.m_flags & 2) != 0;
    }

    public final boolean isDataAvailable() {
        return this.hasStatus() >= 3 && this.hasStatus() < 7;
    }

    public final boolean hasDeleteOnStore() {
        return (this.m_flags & 4) != 0;
    }

    public final void deleteTemporaryFile() throws IOException {
        File tempFile = new File(this.getTemporaryFile());
        if (tempFile.exists() && !tempFile.delete()) {
            Debug.println("** Failed to delete " + this.toString() + " **");
            throw new IOException("Failed to delete file " + this.getTemporaryFile());
        }
    }

    public final int hasStatus() {
        return this.m_status;
    }

    public final long getFileLength() throws IOException {
        File tempFile = new File(this.getTemporaryFile());
        return tempFile.length();
    }

    public final long getReadableLength() {
        return this.m_readable;
    }

    public final void setReadableLength(long readable) {
        this.m_readable = readable;
    }

    public final synchronized void setStatus(int sts) {
        this.m_status = sts;
        this.notifyAll();
    }

    public final void setTemporaryFile(String tempFile) {
        this.m_tempFile = tempFile;
    }

    public final synchronized void setUpdated(boolean sts) {
        this.setFlag(1, sts);
    }

    public final synchronized void setQueued(boolean qd) {
        this.setFlag(2, qd);
    }

    public final synchronized void setDeleteOnStore() {
        if (!this.hasDeleteOnStore()) {
            this.setFlag(4, true);
        }
    }

    protected final synchronized void setFlag(int flag, boolean sts) {
        boolean state;
        boolean bl = state = (this.m_flags & flag) != 0;
        if (state && !sts) {
            this.m_flags -= flag;
        } else if (!state && sts) {
            this.m_flags += flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForData(long tmo) {
        if (!this.isDataAvailable()) {
            FileSegmentInfo fileSegmentInfo = this;
            synchronized (fileSegmentInfo) {
                try {
                    this.wait(tmo);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
    }

    public final synchronized void signalDataAvailable() {
        this.notifyAll();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getTemporaryFile());
        str.append(":");
        str.append(_statusStr[this.hasStatus()]);
        str.append(",");
        if (this.isUpdated()) {
            str.append(",Updated");
        }
        if (this.isQueued()) {
            str.append(",Queued");
        }
        str.append("]");
        return str.toString();
    }
}

