/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.admin;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alfresco.jlan.client.IPCSession;
import org.alfresco.jlan.client.SMBPacket;
import org.alfresco.jlan.client.Session;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.client.admin.ClientTransPacket;
import org.alfresco.jlan.client.admin.DataDecoder;
import org.alfresco.jlan.client.admin.EventlogPipeFile;
import org.alfresco.jlan.client.admin.IPCPipeFile;
import org.alfresco.jlan.client.admin.InitShutPipeFile;
import org.alfresco.jlan.client.admin.LsarpcPipeFile;
import org.alfresco.jlan.client.admin.NetLogonPipeFile;
import org.alfresco.jlan.client.admin.SamrPipeFile;
import org.alfresco.jlan.client.admin.SamrPolicyHandle;
import org.alfresco.jlan.client.admin.SrvsvcPipeFile;
import org.alfresco.jlan.client.admin.SvcctlPipeFile;
import org.alfresco.jlan.client.admin.WinregPipeFile;
import org.alfresco.jlan.client.admin.WkssvcPipeFile;
import org.alfresco.jlan.client.info.PrintJob;
import org.alfresco.jlan.client.info.PrintJobList;
import org.alfresco.jlan.client.info.PrintQueueInfo;
import org.alfresco.jlan.client.info.PrinterList;
import org.alfresco.jlan.client.info.RAPServerInfo;
import org.alfresco.jlan.client.info.RAPServiceInfo;
import org.alfresco.jlan.client.info.RAPSessionInfo;
import org.alfresco.jlan.client.info.RAPShareInfo;
import org.alfresco.jlan.client.info.RAPUserInfo;
import org.alfresco.jlan.client.info.RAPWorkstationInfo;
import org.alfresco.jlan.client.info.ServerList;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.DCEException;
import org.alfresco.jlan.smb.dcerpc.DCEPipeType;
import org.alfresco.jlan.smb.dcerpc.PolicyHandle;
import org.alfresco.jlan.smb.dcerpc.client.DCEPacket;
import org.alfresco.jlan.smb.dcerpc.info.ServerInfo;
import org.alfresco.jlan.smb.dcerpc.info.SessionInfoList;
import org.alfresco.jlan.smb.dcerpc.info.ShareInfo;
import org.alfresco.jlan.smb.dcerpc.info.ShareInfoList;
import org.alfresco.jlan.smb.dcerpc.info.UserInfo;
import org.alfresco.jlan.smb.dcerpc.info.WorkstationInfo;
import org.alfresco.jlan.smb.nt.RID;
import org.alfresco.jlan.smb.nt.RIDList;
import org.alfresco.jlan.smb.nt.SID;
import org.alfresco.jlan.smb.nt.WellKnownSID;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.StringList;

public final class AdminSession {
    private static final int UserInfo0 = 0;
    private static final int UserInfo1 = 1;
    private static final int UserInfo11 = 11;
    private static final int PrintQInfo1 = 1;
    private static final int PrintQInfo2 = 2;
    private static final int PrintQInfo3 = 3;
    private static final int PrintQInfo4 = 4;
    private static final int PrintQInfo5 = 5;
    private static final int PrintJobInfo0 = 0;
    private static final int PrintJobInfo1 = 1;
    private static final int PrintJobInfo2 = 2;
    private static final int PrintJobInfo3 = 3;
    private static final int ServiceInfo0 = 0;
    private static final int ServiceInfo2 = 2;
    private static final int DiskInfo0 = 0;
    private static final int GroupInfo0 = 0;
    private static final int GroupInfo1 = 1;
    private static final int WorkStation10 = 10;
    private IPCSession m_sess;
    private int m_defBufSize = 8192;
    private Hashtable m_pipeCache;
    private SamrPolicyHandle m_samrHandle;
    private SID m_localDomain;
    private boolean m_useDCERPC = true;

    public AdminSession(IPCSession sess) {
        this.m_sess = sess;
        this.m_pipeCache = new Hashtable();
        if (this.m_sess.getMaximumPacketSize() < this.m_defBufSize) {
            this.m_defBufSize = this.m_sess.getMaximumPacketSize();
        }
    }

    public final boolean useDceRpc() {
        return this.m_useDCERPC;
    }

    public final void setUseDceRpc(boolean ena) {
        this.m_useDCERPC = ena;
    }

    public void CloseSession() throws IOException, SMBException {
        this.closePipes();
        this.m_sess.CloseSession();
    }

    public final void ContinuePrintJob(PrintJob job) throws IOException, SMBException {
        this.ManagePrintJob(job, 83);
    }

    public final void ContinuePrintQueue(String qname) throws IOException, SMBException {
        this.ManagePrintQueue(qname, 75);
    }

    public final void DeletePrintJob(PrintJob job) throws IOException, SMBException {
        this.ManagePrintJob(job, 81);
    }

    public int getBufferSize() {
        return this.m_defBufSize;
    }

    public final StringList getDiskList() throws SMBException, IOException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(15, params, 0);
        int pos = DataPacker.putString("WrLeh", params, 2, true);
        pos = DataPacker.putString("B3", params, pos, true);
        DataPacker.putIntelShort(0, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        StringList diskList = new StringList();
        int cnt = prms[2];
        while (cnt-- > 0) {
            Vector objs = new Vector();
            pos = DataDecoder.DecodeData(buf, pos, "B3", objs, conv);
            String name = (String)objs.elementAt(0);
            diskList.addString(name);
        }
        return diskList;
    }

    public final StringList getGroupList() throws SMBException, IOException, DCEException {
        StringList groupList = null;
        if (this.useDceRpc() && this.getSession().supportsRPCAPIs()) {
            SamrPipeFile samrPipe = this.openSecurityAccountsManagerPipe();
            StringList domains = samrPipe.enumerateDomains();
            if (domains != null && domains.numberOfStrings() > 0) {
                groupList = samrPipe.enumerateGroups(domains.getStringAt(0));
            }
        } else {
            groupList = this.getRAPGroupList();
        }
        return groupList;
    }

    public final StringList getGroupUsers(String grpName) throws SMBException, IOException {
        return this.getRAPGroupUsers(grpName);
    }

    public final StringList getUserGroups(String userName) throws SMBException, IOException {
        return this.getRAPUserGroups(userName);
    }

    public final PrintQueueInfo getPrinterInfo(String printerName) throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(70, params, 0);
        int pos = DataPacker.putString("zWrLh", params, 2, true);
        pos = DataPacker.putString("zWWWWzzzzWWzzl", params, pos, true);
        pos = DataPacker.putString(printerName, params, pos, true);
        DataPacker.putIntelShort(3, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 6);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[3];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector objs = new Vector();
        pos = DataDecoder.DecodeData(buf, pos, "zWWWWzzzzWWzzl", objs, conv);
        String str = (String)objs.elementAt(0);
        if (str == null || str.length() == 0) {
            str = printerName;
        }
        PrintQueueInfo qinfo = new PrintQueueInfo(str);
        Short sval = (Short)objs.elementAt(1);
        qinfo.setPriority(sval.intValue());
        qinfo.setSeperatorPage((String)objs.elementAt(5));
        qinfo.setPreProcessor((String)objs.elementAt(6));
        qinfo.setPrinterList((String)objs.elementAt(11));
        qinfo.setParameterString((String)objs.elementAt(7));
        qinfo.setComment((String)objs.elementAt(8));
        sval = (Short)objs.elementAt(9);
        qinfo.setStatus(sval.intValue());
        sval = (Short)objs.elementAt(10);
        qinfo.setJobCount(sval.intValue());
        sval = (Short)objs.elementAt(2);
        qinfo.setStartTime(sval.intValue());
        sval = (Short)objs.elementAt(3);
        qinfo.setStopTime(sval.intValue());
        return qinfo;
    }

    public final PrinterList getPrinterList() throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(69, params, 0);
        int pos = DataPacker.putString("WrLeh", params, 2, true);
        pos = DataPacker.putString("B13BWWWzzzzzWW", params, pos, true);
        DataPacker.putIntelShort(1, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        int cnt = prms[2];
        short tot = prms[3];
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        PrinterList prnList = new PrinterList();
        while (cnt-- > 0) {
            Vector objs = new Vector();
            pos = DataDecoder.DecodeData(buf, pos, "B13.WWWzzzzzWW", objs, conv);
            String str = (String)objs.elementAt(0);
            PrintQueueInfo qinfo = new PrintQueueInfo(str);
            Short sval = (Short)objs.elementAt(1);
            qinfo.setPriority(sval.intValue());
            qinfo.setSeperatorPage((String)objs.elementAt(4));
            qinfo.setPreProcessor((String)objs.elementAt(5));
            qinfo.setPrinterList((String)objs.elementAt(6));
            qinfo.setParameterString((String)objs.elementAt(7));
            sval = (Short)objs.elementAt(9);
            qinfo.setStatus(sval.intValue());
            sval = (Short)objs.elementAt(10);
            qinfo.setJobCount(sval.intValue());
            prnList.addPrinterInfo(qinfo);
        }
        return prnList;
    }

    public final PrintJob getPrintJobInfo(int id) throws SMBException, IOException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(77, params, 0);
        int pos = DataPacker.putString("WWrLh", params, 2, true);
        pos = DataPacker.putString("WWzWWDDzz", params, pos, true);
        DataPacker.putIntelShort(id, params, pos);
        DataPacker.putIntelShort(2, params, pos += 2);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 6);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[3];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector objs = new Vector();
        pos = DataDecoder.DecodeData(buf, pos, "WWzWWDDzz", objs, conv);
        Short sval = (Short)objs.elementAt(0);
        PrintJob prnJob = new PrintJob(sval.intValue());
        sval = (Short)objs.elementAt(1);
        prnJob.setPriority(sval.intValue());
        prnJob.setUserName((String)objs.elementAt(2));
        sval = (Short)objs.elementAt(3);
        prnJob.setPrintPosition(sval.intValue());
        sval = (Short)objs.elementAt(4);
        prnJob.setStatus(sval.intValue());
        Integer ival = (Integer)objs.elementAt(5);
        prnJob.setQueuedDateTime(new Date(ival.longValue() * 1000L));
        ival = (Integer)objs.elementAt(6);
        prnJob.setSpoolFileSize(ival);
        prnJob.setComment((String)objs.elementAt(7));
        prnJob.setDocument((String)objs.elementAt(8));
        return prnJob;
    }

    public final PrintJobList getPrintJobs(String qnam) throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(70, params, 0);
        int pos = DataPacker.putString("zWrLh", params, 2, true);
        pos = DataPacker.putString("B13BWWWzzzzzWN", params, pos, true);
        pos = DataPacker.putString(qnam, params, pos, true);
        DataPacker.putIntelShort(2, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pos += 2;
        pos = DataPacker.putString("WB21BB16B10zWWzDDz", params, pos, true);
        pkt.InitializeTransact(this.m_sess, 14, params, pos, null, 0);
        pkt.setParameter(2, 6);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[3];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        if (prms[1] == 0) {
            return null;
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        PrintJobList jobList = new PrintJobList();
        Vector qobj = new Vector();
        pos = DataDecoder.DecodeData(buf, pos, "B13BWWWzzzzzWN", qobj, conv);
        int cnt = DataPacker.getIntelShort(buf, pos);
        pos += 2;
        while (cnt-- > 0) {
            Vector objs = new Vector();
            pos = DataDecoder.DecodeData(buf, pos, "WB21BB16B10zWWzDDz", objs, conv);
            Short sval = (Short)objs.elementAt(0);
            PrintJob prnJob = new PrintJob(sval.intValue());
            sval = (Short)objs.elementAt(6);
            prnJob.setPriority(sval.intValue());
            prnJob.setUserName((String)objs.elementAt(1));
            Byte bval = (Byte)objs.elementAt(2);
            prnJob.setPrintPosition(sval.intValue());
            sval = (Short)objs.elementAt(7);
            prnJob.setStatus(sval.intValue());
            Integer ival = (Integer)objs.elementAt(9);
            prnJob.setQueuedDateTime(new Date(ival.longValue() * 1000L));
            ival = (Integer)objs.elementAt(10);
            prnJob.setSpoolFileSize(ival);
            prnJob.setComment((String)objs.elementAt(8));
            prnJob.setDocument((String)objs.elementAt(11));
            jobList.addPrintJob(prnJob);
        }
        return jobList;
    }

    private PrintJobList getPrintJobsOld(String qnam) throws SMBException, IOException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(76, params, 0);
        int pos = DataPacker.putString("zWrLeh", params, 2, true);
        pos = DataPacker.putString("WWzWWDDzz", params, pos, true);
        pos = DataPacker.putString(qnam, params, pos, true);
        DataPacker.putIntelShort(2, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 6);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        int cnt = prms[2];
        short tot = prms[3];
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        PrintJobList jobList = new PrintJobList();
        while (cnt-- > 0) {
            Vector objs = new Vector();
            pos = DataDecoder.DecodeData(buf, pos, "WWzWWDDzz", objs, conv);
            Short sval = (Short)objs.elementAt(0);
            PrintJob prnJob = new PrintJob(sval.intValue());
            sval = (Short)objs.elementAt(1);
            prnJob.setPriority(sval.intValue());
            prnJob.setUserName((String)objs.elementAt(2));
            sval = (Short)objs.elementAt(3);
            prnJob.setPrintPosition(sval.intValue());
            sval = (Short)objs.elementAt(4);
            prnJob.setStatus(sval.intValue());
            Integer ival = (Integer)objs.elementAt(5);
            prnJob.setQueuedDateTime(new Date(ival.longValue() * 1000L));
            ival = (Integer)objs.elementAt(6);
            prnJob.setSpoolFileSize(ival);
            prnJob.setComment((String)objs.elementAt(7));
            prnJob.setDocument((String)objs.elementAt(8));
            jobList.addPrintJob(prnJob);
        }
        return jobList;
    }

    public final ServerInfo getServerInfo() throws IOException, SMBException {
        return this.getRAPServerInfo();
    }

    public final ServerInfo getServerInfo(String node) throws SMBException, IOException {
        return this.getRAPServerInfo(node);
    }

    public final ServerList getServerList(int flags) throws IOException, SMBException {
        return this.getRAPServerList(flags);
    }

    public final StringList getServerNames(int flags) throws IOException, SMBException {
        return this.getRAPServerNames(flags);
    }

    public final StringList getServiceList() throws SMBException, IOException {
        return this.getRAPServiceList();
    }

    public Session getSession() {
        return this.m_sess;
    }

    public final SessionInfoList getSessionList() throws SMBException, DCEException, IOException {
        SessionInfoList sessList = null;
        if (this.useDceRpc() && this.getSession().supportsRPCAPIs()) {
            SrvsvcPipeFile srvPipe = this.openServerPipe();
            sessList = srvPipe.getSessionList(null, null);
        } else {
            sessList = this.getRAPSessionList();
        }
        return sessList;
    }

    public final ShareInfo getShareInfo(String shr) throws IOException, SMBException, DCEException {
        ShareInfo shrInfo = null;
        if (this.useDceRpc() && this.getSession().supportsRPCAPIs()) {
            SrvsvcPipeFile srvPipe = this.openServerPipe();
            shrInfo = srvPipe.getShareInformation(shr);
        } else {
            shrInfo = this.getRAPShareInfo(shr);
        }
        return shrInfo;
    }

    public final ShareInfoList getShareList() throws IOException, SMBException, DCEException {
        ShareInfoList shareList = null;
        if (this.useDceRpc() && this.getSession().supportsRPCAPIs()) {
            SrvsvcPipeFile srvPipe = this.openServerPipe();
            shareList = srvPipe.getShareList(true);
        } else {
            shareList = this.getRAPShareList();
        }
        return shareList;
    }

    public final UserInfo getUserInfo(String usr) throws IOException, SMBException {
        return this.getRAPUserInfo(usr);
    }

    public final StringList getUserList() throws IOException, SMBException, DCEException {
        StringList userList = null;
        if (this.useDceRpc() && this.getSession().supportsRPCAPIs()) {
            SamrPipeFile samrPipe = this.openSecurityAccountsManagerPipe();
            StringList domains = samrPipe.enumerateDomains();
            if (domains != null && domains.numberOfStrings() > 0) {
                userList = samrPipe.enumerateUsers(domains.getStringAt(0));
            }
        } else {
            userList = this.getRAPUserList();
        }
        return userList;
    }

    public final WorkstationInfo getWorkstationInfo() throws IOException, SMBException, DCEException {
        WorkstationInfo wksInfo = null;
        if (this.useDceRpc() && this.getSession().supportsRPCAPIs()) {
            WkssvcPipeFile wksPipe = this.openWorkstationPipe();
            wksInfo = wksPipe.getWorkstationInformation();
        } else {
            wksInfo = this.getRAPWorkstationInfo();
        }
        return wksInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getAccountType(String userName) throws IOException, SMBException, DCEException {
        int userType;
        block23: {
            PolicyHandle userHandle;
            PolicyHandle builtinHandle;
            SamrPipeFile samrPipe;
            block24: {
                samrPipe = (SamrPipeFile)this.openDCERPCPipe(1);
                if (this.m_samrHandle == null) {
                    this.m_samrHandle = samrPipe.openService();
                }
                PolicyHandle domainHandle = null;
                builtinHandle = null;
                userHandle = null;
                userType = -1;
                try {
                    StringList domains;
                    if (this.m_localDomain == null && (domains = samrPipe.enumerateDomains()) != null && domains.numberOfStrings() > 0) {
                        this.m_localDomain = samrPipe.lookupDomain(domains.getStringAt(0));
                    }
                    domainHandle = samrPipe.openDomain(this.m_localDomain);
                    builtinHandle = samrPipe.openDomain(WellKnownSID.SIDBuiltinDomain);
                    RIDList rids = samrPipe.lookupName(domainHandle, userName);
                    RID userRID = rids.findRID(userName, 1);
                    if (userRID != null) {
                        userHandle = samrPipe.openUser(domainHandle, userRID);
                        RIDList groups = samrPipe.getGroupsForUser(userHandle);
                        if (groups != null) {
                            if (groups.findRID(512, 5) != null) {
                                userType = 2;
                            } else if (groups.findRID(513, 5) != null) {
                                userType = 1;
                            } else if (groups.findRID(514, 5) != null) {
                                userType = 0;
                            }
                        }
                        SID userSID = new SID(this.m_localDomain);
                        userSID.setRID(userRID.getRID());
                        RIDList aliases = samrPipe.getAliasesForUser(builtinHandle, userSID);
                        if (aliases != null) {
                            if (aliases.findRID(544, 4) != null) {
                                userType = 2;
                            } else if (aliases.findRID(545, 4) != null) {
                                userType = 1;
                            } else if (aliases.findRID(546, 4) != null) {
                                userType = 0;
                            }
                        }
                    }
                    if (samrPipe == null) break block23;
                    if (domainHandle == null) break block24;
                }
                catch (Throwable throwable) {
                    if (samrPipe != null) {
                        if (domainHandle != null) {
                            samrPipe.closeHandle(domainHandle);
                        }
                        if (builtinHandle != null) {
                            samrPipe.closeHandle(builtinHandle);
                        }
                        if (userHandle != null) {
                            samrPipe.closeHandle(userHandle);
                        }
                    }
                    throw throwable;
                }
                samrPipe.closeHandle(domainHandle);
            }
            if (builtinHandle != null) {
                samrPipe.closeHandle(builtinHandle);
            }
            if (userHandle != null) {
                samrPipe.closeHandle(userHandle);
            }
        }
        return userType;
    }

    private final void ManagePrintJob(PrintJob job, int func) throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[64];
        DataPacker.putIntelShort(func, params, 0);
        int pos = DataPacker.putString("W", params, 2, true);
        pos = DataPacker.putString("", params, pos, true);
        DataPacker.putIntelShort(job.getJobNumber(), params, pos);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 2);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[2];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
    }

    private void ManagePrintQueue(String qname, int func) throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[64];
        DataPacker.putIntelShort(func, params, 0);
        int pos = DataPacker.putString("z", params, 2, true);
        pos = DataPacker.putString("", params, pos, true);
        pos = DataPacker.putString(qname, params, pos, true);
        pkt.InitializeTransact(this.m_sess, 14, params, pos, null, 0);
        pkt.setParameter(2, 2);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[2];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
    }

    public final void PausePrintJob(PrintJob job) throws IOException, SMBException {
        this.ManagePrintJob(job, 82);
    }

    public final void PausePrintQueue(String qname) throws IOException, SMBException {
        this.ManagePrintQueue(qname, 74);
    }

    public final WinregPipeFile openWindowsRegistryPipe() throws IOException, SMBException, DCEException {
        return (WinregPipeFile)this.openDCERPCPipe(2);
    }

    public final SrvsvcPipeFile openServerPipe() throws IOException, SMBException, DCEException {
        return (SrvsvcPipeFile)this.openDCERPCPipe(0);
    }

    public final WkssvcPipeFile openWorkstationPipe() throws IOException, SMBException, DCEException {
        return (WkssvcPipeFile)this.openDCERPCPipe(3);
    }

    public final EventlogPipeFile openEventLogPipe() throws IOException, SMBException, DCEException {
        return (EventlogPipeFile)this.openDCERPCPipe(9);
    }

    public final SvcctlPipeFile openServiceManagerPipe() throws IOException, SMBException, DCEException {
        return (SvcctlPipeFile)this.openDCERPCPipe(8);
    }

    public final SamrPipeFile openSecurityAccountsManagerPipe() throws IOException, SMBException, DCEException {
        return (SamrPipeFile)this.openDCERPCPipe(1);
    }

    public final InitShutPipeFile openInitShutdownPipe() throws IOException, SMBException, DCEException {
        return (InitShutPipeFile)this.openDCERPCPipe(11);
    }

    public void setBufferSize(int siz) {
        if (siz >= 8192 && siz <= 65535) {
            this.m_defBufSize = siz;
        }
    }

    public final IPCPipeFile openPipe(int pipeId) throws IOException, SMBException, DCEException {
        if (!this.getSession().supportsRPCAPIs()) {
            throw new DCEException("Server does not support DCE/RPC");
        }
        String pipeName = DCEPipeType.getTypeAsStringShort(pipeId);
        if (pipeName == null) {
            throw new DCEException("Invalid pipe id " + pipeId);
        }
        SMBPacket pkt = new SMBPacket();
        pkt.setFlags(this.m_sess.getDefaultFlags());
        pkt.setFlags2(this.m_sess.getDefaultFlags2());
        pkt.setCommand(162);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.setParameterCount(24);
        pkt.resetParameterPointer();
        pkt.packByte(255);
        pkt.packByte(0);
        pkt.packWord(0);
        pkt.packByte(0);
        int nameLen = pipeName.length();
        if (pkt.isUnicode()) {
            nameLen = nameLen * 2 + 2;
        }
        pkt.packWord(nameLen);
        pkt.packInt(0);
        pkt.packInt(0);
        pkt.packInt(131487);
        pkt.packLong(0L);
        pkt.packInt(0);
        pkt.packInt(3);
        pkt.packInt(1);
        pkt.packInt(0);
        pkt.packInt(2);
        pkt.packByte(0);
        pkt.resetBytePointer();
        pkt.packString(pipeName, pkt.isUnicode());
        pkt.setByteCount();
        pkt.ExchangeSMB(this.m_sess, pkt, true);
        pkt.resetParameterPointer();
        pkt.skipBytes(5);
        int pipeHandle = pkt.unpackWord();
        DCEPacket dcePkt = new DCEPacket(65535, pkt);
        dcePkt.initializeDCEBind(pipeHandle, 4280, 4280, pipeId, 1);
        dcePkt.setUserId(this.m_sess.getUserId());
        dcePkt.setTreeId(this.m_sess.getTreeId());
        dcePkt.ExchangeSMB(this.m_sess, dcePkt);
        if (!dcePkt.isValidResponse()) {
            throw new SMBException(dcePkt.getErrorClass(), dcePkt.getErrorCode());
        }
        DCEBuffer ackBuf = new DCEBuffer(dcePkt.getBuffer(), dcePkt.getDCEDataOffset());
        int maxTxSize = -1;
        int maxRxSize = -1;
        try {
            maxTxSize = ackBuf.getShort();
            maxRxSize = ackBuf.getShort();
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        IPCPipeFile pipeFile = null;
        switch (pipeId) {
            case 0: {
                pipeFile = new SrvsvcPipeFile(this.m_sess, dcePkt, pipeHandle, pipeName, maxTxSize, maxRxSize);
                break;
            }
            case 2: {
                pipeFile = new WinregPipeFile(this.m_sess, dcePkt, pipeHandle, pipeName, maxTxSize, maxRxSize);
                break;
            }
            case 8: {
                pipeFile = new SvcctlPipeFile(this.m_sess, dcePkt, pipeHandle, pipeName, maxTxSize, maxRxSize);
                break;
            }
            case 9: {
                pipeFile = new EventlogPipeFile(this.m_sess, dcePkt, pipeHandle, pipeName, maxTxSize, maxRxSize);
                break;
            }
            case 5: {
                pipeFile = new LsarpcPipeFile(this.m_sess, dcePkt, pipeHandle, pipeName, maxTxSize, maxRxSize);
                break;
            }
            case 1: {
                pipeFile = new SamrPipeFile(this.m_sess, dcePkt, pipeHandle, pipeName, maxTxSize, maxRxSize);
                break;
            }
            case 4: {
                pipeFile = new NetLogonPipeFile(this.m_sess, dcePkt, pipeHandle, pipeName, maxTxSize, maxRxSize);
                break;
            }
            case 11: {
                pipeFile = new InitShutPipeFile(this.m_sess, dcePkt, pipeHandle, pipeName, maxTxSize, maxRxSize);
                break;
            }
            case 3: {
                pipeFile = new WkssvcPipeFile(this.m_sess, dcePkt, pipeHandle, pipeName, maxTxSize, maxRxSize);
            }
        }
        return pipeFile;
    }

    private final IPCPipeFile openDCERPCPipe(int pipeType) throws IOException, SMBException, DCEException {
        if (!this.getSession().supportsRPCAPIs()) {
            throw new DCEException("Server does not support DCE/RPC");
        }
        String pipeName = DCEPipeType.getTypeAsString(pipeType);
        IPCPipeFile pipeFile = (IPCPipeFile)this.m_pipeCache.get(pipeName);
        if (pipeFile != null && pipeFile.isClosed()) {
            this.m_pipeCache.remove(pipeName);
            pipeFile = null;
        }
        if (pipeFile != null) {
            return pipeFile;
        }
        pipeFile = this.openPipe(pipeType);
        if (pipeFile != null) {
            this.m_pipeCache.put(pipeName, pipeFile);
        }
        return pipeFile;
    }

    public final void closePipes() {
        SamrPipeFile samrPipe;
        if (this.m_samrHandle != null && (samrPipe = (SamrPipeFile)this.m_pipeCache.get(DCEPipeType.getTypeAsString(1))) != null && !samrPipe.isClosed()) {
            try {
                samrPipe.closeHandle(this.m_samrHandle);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_samrHandle = null;
            this.m_localDomain = null;
        }
        Enumeration enm = this.m_pipeCache.elements();
        while (enm.hasMoreElements()) {
            IPCPipeFile pipeFile = (IPCPipeFile)enm.nextElement();
            if (pipeFile.isClosed()) continue;
            try {
                pipeFile.ClosePipe();
            }
            catch (Exception exception) {}
        }
        this.m_pipeCache.clear();
    }

    private final StringList getRAPGroupList() throws SMBException, IOException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(47, params, 0);
        int pos = DataPacker.putString("WrLeh", params, 2, true);
        pos = DataPacker.putString("B21", params, pos, true);
        DataPacker.putIntelShort(0, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector grpList = new Vector();
        int cnt = prms[3];
        while (cnt-- > 0) {
            pos = DataDecoder.DecodeData(buf, pos, "B21", grpList, conv);
        }
        return new StringList(grpList);
    }

    private final StringList getRAPGroupUsers(String grpName) throws SMBException, IOException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(52, params, 0);
        int pos = DataPacker.putString("zWrLeh", params, 2, true);
        pos = DataPacker.putString("B21", params, pos, true);
        pos = DataPacker.putString(grpName, params, pos, true);
        DataPacker.putIntelShort(0, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector usrList = new Vector();
        int cnt = prms[3];
        while (cnt-- > 0) {
            pos = DataDecoder.DecodeData(buf, pos, "B21", usrList, conv);
        }
        return new StringList(usrList);
    }

    private final ServerInfo getRAPServerInfo() throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(13, params, 0);
        int pos = DataPacker.putString("WrLh", params, 2, true);
        pos = DataPacker.putString("B16BBDz", params, pos, true);
        DataPacker.putIntelShort(1, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 6);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[3];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector objs = new Vector();
        DataDecoder.DecodeData(buf, pos, "B16BBDz", objs, conv);
        RAPServerInfo srvinfo = new RAPServerInfo(1, objs, false);
        return srvinfo;
    }

    private final ServerInfo getRAPServerInfo(String node) throws SMBException, IOException {
        if (node.equalsIgnoreCase(this.m_sess.getServer())) {
            return this.getRAPServerInfo();
        }
        PCShare srvShr = new PCShare(node, "", "", "");
        AdminSession admSess = SessionFactory.OpenAdminSession(srvShr);
        ServerInfo srvInfo = admSess.getRAPServerInfo();
        admSess.CloseSession();
        return srvInfo;
    }

    private final ServerList getRAPServerList(int flags) throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[128];
        DataPacker.putIntelShort(104, params, 0);
        int pos = 0;
        pos = DataPacker.putString("WrLehDz", params, 2, true);
        pos = DataPacker.putString("B16BBDz", params, pos, true);
        DataPacker.putIntelShort(1, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize - 70, params, pos += 2);
        DataPacker.putIntelInt(flags, params, pos += 2);
        pos += 4;
        boolean domainEnum = false;
        if ((flags & Integer.MIN_VALUE) != 0) {
            domainEnum = true;
        }
        pos = this.m_sess.getDomain() == null || domainEnum ? DataPacker.putString("", params, pos, true) : DataPacker.putString(this.m_sess.getDomain(), params, pos, true);
        pkt.InitializeTransact(this.m_sess, 14, params, pos, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new IOException("Transaction failed");
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        int nsrv = prms[2];
        short totsrv = prms[3];
        ServerList srvList = new ServerList();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        while (nsrv-- > 0) {
            Vector objs = new Vector();
            pos = DataDecoder.DecodeData(buf, pos, "B16BBDz", objs, conv);
            RAPServerInfo srvinfo = new RAPServerInfo(1, objs, domainEnum);
            srvList.addServerInfo(srvinfo);
        }
        return srvList;
    }

    private final StringList getRAPServerNames(int flags) throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[128];
        DataPacker.putIntelShort(104, params, 0);
        int pos = 0;
        pos = this.m_sess.getDialectString().equalsIgnoreCase("NT LM 0.12") || this.m_sess.getOperatingSystem() != null && this.m_sess.getOperatingSystem().startsWith("Windows NT 4") ? DataPacker.putString("WrLehDz", params, 2, true) : DataPacker.putString("WrLehD0", params, 2, true);
        pos = DataPacker.putString("B16", params, pos, true);
        DataPacker.putIntelShort(0, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize - 70, params, pos += 2);
        DataPacker.putIntelInt(flags, params, pos += 2);
        pos += 4;
        boolean domainEnum = false;
        if ((flags & Integer.MIN_VALUE) != 0) {
            domainEnum = true;
        }
        pos = this.m_sess.getDomain() == null || domainEnum ? DataPacker.putString("", params, pos, true) : DataPacker.putString(this.m_sess.getDomain(), params, pos, true);
        pkt.InitializeTransact(this.m_sess, 14, params, pos, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new IOException("Transaction failed");
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        int nsrv = prms[2];
        short totsrv = prms[3];
        Vector<String> srvList = new Vector<String>();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        while (nsrv-- > 0) {
            Vector objs = new Vector();
            pos = DataDecoder.DecodeData(buf, pos, "B16", objs, conv);
            String name = (String)objs.elementAt(0);
            srvList.addElement(name);
        }
        return new StringList(srvList);
    }

    private final StringList getRAPServiceList() throws SMBException, IOException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(39, params, 0);
        int pos = DataPacker.putString("WrLeh", params, 2, true);
        pos = DataPacker.putString("B16WDWB64", params, pos, true);
        DataPacker.putIntelShort(2, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector<RAPServiceInfo> srvList = new Vector<RAPServiceInfo>();
        int cnt = prms[2];
        while (cnt-- > 0) {
            Vector objs = new Vector();
            pos = DataDecoder.DecodeData(buf, pos, "B16WDWB64", objs, conv);
            RAPServiceInfo srvInfo = new RAPServiceInfo(2, objs);
            srvList.addElement(srvInfo);
        }
        return new StringList(srvList);
    }

    private final SessionInfoList getRAPSessionList() throws SMBException, IOException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[128];
        DataPacker.putIntelShort(6, params, 0);
        int pos = DataPacker.putString("WrLeh", params, 2, true);
        pos = DataPacker.putString("zzWWWDDD", params, pos, true);
        DataPacker.putIntelShort(1, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new IOException("Transaction failed");
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        int nsess = prms[2];
        short totsess = prms[3];
        SessionInfoList sessList = new SessionInfoList();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        while (nsess-- > 0) {
            Vector objs = new Vector();
            pos = DataDecoder.DecodeData(buf, pos, "zzWWWDDD", objs, conv);
            RAPSessionInfo sessInfo = new RAPSessionInfo(1, objs);
            sessList.addSession(sessInfo);
        }
        return sessList;
    }

    private final ShareInfo getRAPShareInfo(String shr) throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(1, params, 0);
        int pos = DataPacker.putString("zWrLh", params, 2, true);
        pos = DataPacker.putString("B13BWzWWWzB9B", params, pos, true);
        pos = DataPacker.putString(shr, params, pos, true);
        DataPacker.putIntelShort(2, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 6);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[3];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector objs = new Vector();
        DataDecoder.DecodeData(buf, pos, "B13.WzWWWzB9.", objs, conv);
        return new RAPShareInfo(2, objs);
    }

    private final ShareInfoList getRAPShareList() throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[64];
        DataPacker.putIntelShort(0, params, 0);
        int pos = DataPacker.putString("WrLeh", params, 2, true);
        pos = DataPacker.putString("B13BWz", params, pos, true);
        DataPacker.putIntelShort(1, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        int nshr = prms[2];
        short totshr = prms[3];
        if (prms[0] == 234) {
            this.m_sess.pingServer(1);
        }
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector objs = new Vector();
        ShareInfoList shrList = new ShareInfoList();
        while (nshr-- > 0) {
            pos = DataDecoder.DecodeData(buf, pos, "B13.Wz", objs, conv);
            RAPShareInfo shrinfo = new RAPShareInfo(1, objs);
            shrList.addShare(shrinfo);
            objs.removeAllElements();
        }
        return shrList;
    }

    public final StringList getRAPUserGroups(String userName) throws SMBException, IOException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(59, params, 0);
        int pos = DataPacker.putString("zWrLeh", params, 2, true);
        pos = DataPacker.putString("B21", params, pos, true);
        pos = DataPacker.putString(userName, params, pos, true);
        DataPacker.putIntelShort(0, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector usrList = new Vector();
        int cnt = prms[3];
        while (cnt-- > 0) {
            pos = DataDecoder.DecodeData(buf, pos, "B21", usrList, conv);
        }
        return new StringList(usrList);
    }

    private final UserInfo getRAPUserInfo(String usr) throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(56, params, 0);
        int pos = DataPacker.putString("zWrLh", params, 2, true);
        pos = DataPacker.putString("B21BzzzWDDzzDDWWzWzDWB21W", params, pos, true);
        pos = DataPacker.putString(usr, params, pos, true);
        DataPacker.putIntelShort(11, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 6);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[3];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector objs = new Vector();
        DataDecoder.DecodeData(buf, pos, "B21.zzzWDDz.4TTWWzWzDWB21W", objs, conv);
        return new RAPUserInfo(11, objs);
    }

    private final StringList getRAPUserList() throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(53, params, 0);
        int pos = DataPacker.putString("WrLeh", params, 2, true);
        pos = DataPacker.putString("B21", params, pos, true);
        DataPacker.putIntelShort(0, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 8);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[4];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector usrList = new Vector();
        int cnt = prms[3];
        while (cnt-- > 0) {
            pos = DataDecoder.DecodeData(buf, pos, "B21", usrList, conv);
        }
        return new StringList(usrList);
    }

    private final WorkstationInfo getRAPWorkstationInfo() throws IOException, SMBException {
        ClientTransPacket pkt = new ClientTransPacket(this.m_defBufSize);
        pkt.setTransactionName("\\PIPE\\LANMAN");
        byte[] params = new byte[256];
        DataPacker.putIntelShort(63, params, 0);
        int pos = DataPacker.putString("WrLh", params, 2, true);
        pos = DataPacker.putString("zzzBBzz", params, pos, true);
        DataPacker.putIntelShort(10, params, pos);
        DataPacker.putIntelShort(this.m_defBufSize, params, pos += 2);
        pkt.InitializeTransact(this.m_sess, 14, params, pos += 2, null, 0);
        pkt.setParameter(2, 6);
        pkt.setParameter(3, this.m_defBufSize - 70);
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.ExchangeSMB(this.m_sess, pkt);
        if (!pkt.isValidResponse()) {
            throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
        }
        short[] prms = new short[3];
        pkt.getParameterBlock(prms);
        if (prms[0] != 0 && prms[0] != 234) {
            throw new SMBException(4, prms[0]);
        }
        int conv = prms[1] - pkt.getDataOffset();
        byte[] buf = pkt.getBuffer();
        pos = pkt.getDataOffset();
        Vector objs = new Vector();
        DataDecoder.DecodeData(buf, pos, "zzzBBzz", objs, conv);
        return new RAPWorkstationInfo(10, objs);
    }
}

