/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.io.IOException;
import java.io.OutputStream;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.smb.SMBException;

public class SMBOutputStream
extends OutputStream {
    private SMBFile m_file;

    protected SMBOutputStream(SMBFile sfile) {
        this.m_file = sfile;
    }

    @Override
    public void close() throws IOException {
        try {
            this.m_file.Close();
        }
        catch (SMBException ex) {
            throw new IOException(ex.getErrorText());
        }
    }

    public final SMBFile File() {
        return this.m_file;
    }

    @Override
    public void flush() throws IOException {
        try {
            this.m_file.Flush();
        }
        catch (SMBException ex) {
            throw new IOException(ex.getErrorText());
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        try {
            this.m_file.Write(buf, len, off);
        }
        catch (SMBException ex) {
            throw new IOException(ex.getErrorText());
        }
    }

    @Override
    public void write(int byt) throws IOException {
        byte[] buf = new byte[2];
        buf[0] = (byte)byt;
        try {
            this.m_file.Write(buf, 1, 0);
        }
        catch (SMBException ex) {
            throw new IOException(ex.getErrorText());
        }
    }
}

