/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept;

import java.util.HashSet;
import java.util.Iterator;
import org.acegisecurity.AccessDecisionManager;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.AfterInvocationManager;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationCredentialsNotFoundException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.RunAsManager;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.event.authorization.AuthenticationCredentialsNotFoundEvent;
import org.acegisecurity.event.authorization.AuthorizationFailureEvent;
import org.acegisecurity.event.authorization.AuthorizedEvent;
import org.acegisecurity.event.authorization.PublicInvocationEvent;
import org.acegisecurity.intercept.InterceptorStatusToken;
import org.acegisecurity.intercept.ObjectDefinitionSource;
import org.acegisecurity.runas.NullRunAsManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;

public abstract class AbstractSecurityInterceptor
implements InitializingBean,
ApplicationEventPublisherAware,
MessageSourceAware {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$intercept$AbstractSecurityInterceptor == null ? (class$org$acegisecurity$intercept$AbstractSecurityInterceptor = AbstractSecurityInterceptor.class$("org.acegisecurity.intercept.AbstractSecurityInterceptor")) : class$org$acegisecurity$intercept$AbstractSecurityInterceptor));
    private AccessDecisionManager accessDecisionManager;
    private AfterInvocationManager afterInvocationManager;
    private ApplicationEventPublisher eventPublisher;
    private AuthenticationManager authenticationManager;
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private RunAsManager runAsManager = new NullRunAsManager();
    private boolean alwaysReauthenticate = false;
    private boolean rejectPublicInvocations = false;
    private boolean validateConfigAttributes = true;
    static /* synthetic */ Class class$org$acegisecurity$intercept$AbstractSecurityInterceptor;

    protected Object afterInvocation(InterceptorStatusToken token, Object returnedObject) {
        if (token == null) {
            return returnedObject;
        }
        if (token.isContextHolderRefreshRequired()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reverting to original Authentication: " + token.getAuthentication().toString()));
            }
            SecurityContextHolder.getContext().setAuthentication(token.getAuthentication());
        }
        if (this.afterInvocationManager != null) {
            try {
                returnedObject = this.afterInvocationManager.decide(token.getAuthentication(), token.getSecureObject(), token.getAttr(), returnedObject);
            }
            catch (AccessDeniedException accessDeniedException) {
                AuthorizationFailureEvent event = new AuthorizationFailureEvent(token.getSecureObject(), token.getAttr(), token.getAuthentication(), accessDeniedException);
                this.publishEvent(event);
                throw accessDeniedException;
            }
        }
        return returnedObject;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getSecureObjectClass(), (String)"Subclass must provide a non-null response to getSecureObjectClass()");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager is required");
        Assert.notNull((Object)this.accessDecisionManager, (String)"An AccessDecisionManager is required");
        Assert.notNull((Object)this.runAsManager, (String)"A RunAsManager is required");
        Assert.notNull((Object)this.obtainObjectDefinitionSource(), (String)"An ObjectDefinitionSource is required");
        Assert.isTrue((boolean)this.obtainObjectDefinitionSource().supports(this.getSecureObjectClass()), (String)("ObjectDefinitionSource does not support secure object class: " + this.getSecureObjectClass()));
        Assert.isTrue((boolean)this.runAsManager.supports(this.getSecureObjectClass()), (String)("RunAsManager does not support secure object class: " + this.getSecureObjectClass()));
        Assert.isTrue((boolean)this.accessDecisionManager.supports(this.getSecureObjectClass()), (String)("AccessDecisionManager does not support secure object class: " + this.getSecureObjectClass()));
        if (this.afterInvocationManager != null) {
            Assert.isTrue((boolean)this.afterInvocationManager.supports(this.getSecureObjectClass()), (String)("AfterInvocationManager does not support secure object class: " + this.getSecureObjectClass()));
        }
        if (this.validateConfigAttributes) {
            Iterator iter = this.obtainObjectDefinitionSource().getConfigAttributeDefinitions();
            if (iter == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"Could not validate configuration attributes as the MethodDefinitionSource did not return a ConfigAttributeDefinition Iterator");
                }
            } else {
                HashSet<ConfigAttribute> set = new HashSet<ConfigAttribute>();
                while (iter.hasNext()) {
                    ConfigAttributeDefinition def = (ConfigAttributeDefinition)iter.next();
                    Iterator attributes = def.getConfigAttributes();
                    while (attributes.hasNext()) {
                        ConfigAttribute attr = (ConfigAttribute)attributes.next();
                        if (this.runAsManager.supports(attr) || this.accessDecisionManager.supports(attr) || this.afterInvocationManager != null && this.afterInvocationManager.supports(attr)) continue;
                        set.add(attr);
                    }
                }
                if (set.size() == 0) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Validated configuration attributes");
                    }
                } else {
                    throw new IllegalArgumentException("Unsupported configuration attributes: " + ((Object)set).toString());
                }
            }
        }
    }

    protected InterceptorStatusToken beforeInvocation(Object object) {
        Assert.notNull((Object)object, (String)"Object was null");
        if (!this.getSecureObjectClass().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Security invocation attempted for object " + object.getClass().getName() + " but AbstractSecurityInterceptor only configured to support secure objects of type: " + this.getSecureObjectClass());
        }
        ConfigAttributeDefinition attr = this.obtainObjectDefinitionSource().getAttributes(object);
        if (attr == null && this.rejectPublicInvocations) {
            throw new IllegalArgumentException("No public invocations are allowed via this AbstractSecurityInterceptor. This indicates a configuration error because the AbstractSecurityInterceptor.rejectPublicInvocations property is set to 'true'");
        }
        if (attr != null) {
            Authentication authenticated;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Secure object: " + object.toString() + "; ConfigAttributes: " + attr.toString()));
            }
            if (SecurityContextHolder.getContext().getAuthentication() == null) {
                this.credentialsNotFound(this.messages.getMessage("AbstractSecurityInterceptor.authenticationNotFound", "An Authentication object was not found in the SecurityContext"), object, attr);
            }
            if (!SecurityContextHolder.getContext().getAuthentication().isAuthenticated() || this.alwaysReauthenticate) {
                authenticated = this.authenticationManager.authenticate(SecurityContextHolder.getContext().getAuthentication());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully Authenticated: " + authenticated.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication(authenticated);
            } else {
                authenticated = SecurityContextHolder.getContext().getAuthentication();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Previously Authenticated: " + authenticated.toString()));
                }
            }
            try {
                this.accessDecisionManager.decide(authenticated, object, attr);
            }
            catch (AccessDeniedException accessDeniedException) {
                AuthorizationFailureEvent event = new AuthorizationFailureEvent(object, attr, authenticated, accessDeniedException);
                this.publishEvent(event);
                throw accessDeniedException;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authorization successful");
            }
            AuthorizedEvent event = new AuthorizedEvent(object, attr, authenticated);
            this.publishEvent(event);
            Authentication runAs = this.runAsManager.buildRunAs(authenticated, object, attr);
            if (runAs == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RunAsManager did not change Authentication object");
                }
                return new InterceptorStatusToken(authenticated, false, attr, object);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Switching to RunAs Authentication: " + runAs.toString()));
            }
            SecurityContextHolder.getContext().setAuthentication(runAs);
            return new InterceptorStatusToken(authenticated, true, attr, object);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Public object - authentication not attempted");
        }
        this.publishEvent(new PublicInvocationEvent(object));
        return null;
    }

    private void credentialsNotFound(String reason, Object secureObject, ConfigAttributeDefinition configAttribs) {
        AuthenticationCredentialsNotFoundException exception = new AuthenticationCredentialsNotFoundException(reason);
        AuthenticationCredentialsNotFoundEvent event = new AuthenticationCredentialsNotFoundEvent(secureObject, configAttribs, exception);
        this.publishEvent(event);
        throw exception;
    }

    public AccessDecisionManager getAccessDecisionManager() {
        return this.accessDecisionManager;
    }

    public AfterInvocationManager getAfterInvocationManager() {
        return this.afterInvocationManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public RunAsManager getRunAsManager() {
        return this.runAsManager;
    }

    public abstract Class getSecureObjectClass();

    public boolean isAlwaysReauthenticate() {
        return this.alwaysReauthenticate;
    }

    public boolean isRejectPublicInvocations() {
        return this.rejectPublicInvocations;
    }

    public boolean isValidateConfigAttributes() {
        return this.validateConfigAttributes;
    }

    public abstract ObjectDefinitionSource obtainObjectDefinitionSource();

    public void setAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
    }

    public void setAfterInvocationManager(AfterInvocationManager afterInvocationManager) {
        this.afterInvocationManager = afterInvocationManager;
    }

    public void setAlwaysReauthenticate(boolean alwaysReauthenticate) {
        this.alwaysReauthenticate = alwaysReauthenticate;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setAuthenticationManager(AuthenticationManager newManager) {
        this.authenticationManager = newManager;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setRejectPublicInvocations(boolean rejectPublicInvocations) {
        this.rejectPublicInvocations = rejectPublicInvocations;
    }

    public void setRunAsManager(RunAsManager runAsManager) {
        this.runAsManager = runAsManager;
    }

    public void setValidateConfigAttributes(boolean validateConfigAttributes) {
        this.validateConfigAttributes = validateConfigAttributes;
    }

    private void publishEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

