/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import nu.zoom.catonine.stylerule.StyleRulesManager;

public final class StyleRulesManagerPersistence {
    public static final void save(StyleRulesManager manager, File file) throws IOException, JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{StyleRulesManager.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)manager, file);
    }

    public static final StyleRulesManager readManager(File managerFile) throws FileCanNotBeReadException, JAXBException, FileNotFoundException, IOException, ClassNotFoundException {
        StyleRulesManager newManager;
        if (!managerFile.exists()) {
            throw new FileNotFoundException("Style rules manager file: " + managerFile + " does not exist");
        }
        if (!managerFile.canRead()) {
            throw new FileCanNotBeReadException("Unable to read file: " + managerFile);
        }
        if (managerFile.getName().endsWith("xml")) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{StyleRulesManager.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            newManager = (StyleRulesManager)unmarshaller.unmarshal(managerFile);
        } else {
            ObjectInputStream objIns = new ObjectInputStream(new FileInputStream(managerFile));
            newManager = (StyleRulesManager)objIns.readObject();
        }
        return newManager;
    }

    public static class FileCanNotBeReadException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FileCanNotBeReadException(String message) {
            super(message);
        }
    }
}

